/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.Comparators;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;
import org.onosproject.net.region.RegionService;

@Command(scope="onos", name="regions", description="List Region details including membership")
public class RegionListCommand
extends AbstractShellCommand {
    private static final String FMT = "id=%s, name=%s, type=%s";
    private static final String FMT_MASTER = "  master=%s";
    @Argument(index=0, name="id", description="Region ID", required=false, multiValued=false)
    String id = null;

    @Override
    protected void execute() {
        RegionService regionService = RegionListCommand.get(RegionService.class);
        if (this.id == null) {
            for (Region region : this.getSortedRegions(regionService)) {
                this.printRegion(region);
            }
        } else {
            Region region = regionService.getRegion(RegionId.regionId((String)this.id));
            if (region == null) {
                this.error("No such region %s", this.id);
            } else {
                this.printRegion(region);
            }
        }
    }

    protected List<Region> getSortedRegions(RegionService service) {
        ArrayList regions = Lists.newArrayList((Iterable)service.getRegions());
        Collections.sort(regions, Comparators.REGION_COMPARATOR);
        return regions;
    }

    private void printRegion(Region region) {
        this.print(FMT, region.id(), region.name(), region.type());
        region.masters().forEach(m -> this.print(FMT_MASTER, m));
    }
}

