/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.Comparators;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TableStatisticsEntry;

@Command(scope="onos", name="tablestats", description="Lists statistics of all tables in the device")
public class TableStatisticsCommand
extends AbstractShellCommand {
    @Option(name="-t", aliases={"--table"}, description="Show human readable table format for statistics", required=false, multiValued=false)
    private boolean table = false;
    @Argument(index=0, name="uri", description="Device ID", required=false, multiValued=false)
    String uri = null;
    private static final String FORMAT = "   table=%s, active=%s, lookedup=%s, matched=%s";

    @Override
    protected void execute() {
        FlowRuleService flowService = TableStatisticsCommand.get(FlowRuleService.class);
        DeviceService deviceService = TableStatisticsCommand.get(DeviceService.class);
        SortedMap<Device, List<TableStatisticsEntry>> deviceTableStats = this.getSortedTableStats(deviceService, flowService);
        if (this.outputJson()) {
            this.print("%s", this.json(deviceTableStats.keySet(), deviceTableStats));
        } else {
            deviceTableStats.forEach((device, tableStats) -> this.printTableStats((Device)device, (List<TableStatisticsEntry>)tableStats));
        }
    }

    private JsonNode json(Iterable<Device> devices, Map<Device, List<TableStatisticsEntry>> deviceTableStats) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Device device : devices) {
            result.add((JsonNode)this.json(mapper, device, deviceTableStats.get(device)));
        }
        return result;
    }

    private ObjectNode json(ObjectMapper mapper, Device device, List<TableStatisticsEntry> tableStats) {
        ObjectNode result = mapper.createObjectNode();
        ArrayNode array = mapper.createArrayNode();
        tableStats.forEach(tableStat -> array.add((JsonNode)this.jsonForEntity(tableStat, TableStatisticsEntry.class)));
        result.put("device", device.id().toString()).put("tableCount", tableStats.size()).set("tables", (JsonNode)array);
        return result;
    }

    protected void printTableStats(Device d, List<TableStatisticsEntry> tableStats) {
        boolean empty = tableStats == null || tableStats.isEmpty();
        this.print("deviceId=%s, tableCount=%d", d.id(), empty ? 0 : tableStats.size());
        if (!empty) {
            for (TableStatisticsEntry t : tableStats) {
                this.print(FORMAT, t.tableId(), t.activeFlowEntries(), t.packetsLookedup(), t.packetsMatched());
            }
        }
    }

    protected SortedMap<Device, List<TableStatisticsEntry>> getSortedTableStats(DeviceService deviceService, FlowRuleService flowService) {
        TreeMap<Element, ArrayList> deviceTableStats = new TreeMap<Element, ArrayList>(Comparators.ELEMENT_COMPARATOR);
        List<Device> devices = this.uri == null ? deviceService.getDevices() : Collections.singletonList(deviceService.getDevice(DeviceId.deviceId((String)this.uri)));
        for (Device d : devices) {
            ArrayList tableStatsList = Lists.newArrayList((Iterable)flowService.getFlowTableStatistics(d.id()));
            tableStatsList.sort((p1, p2) -> Integer.valueOf(p1.tableId()).compareTo(p2.tableId()));
            deviceTableStats.put((Element)d, tableStatsList);
        }
        return deviceTableStats;
    }
}

