/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.VlanId;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.InterfaceConfig;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;

@Command(scope="onos", name="device-remove-interface", description="Removes an interface configuration from a device")
public class DeviceInterfaceRemoveCommand
extends AbstractShellCommand {
    private static final String REMOVE_VLAN_SUCCESS = "VLAN %s removed from device %s interface %s.";
    private static final String REMOVE_VLAN_FAILURE = "Failed to remove VLAN %s from device %s interface %s.";
    private static final String REMOVE_TRUNK_SUCCESS = "Trunk mode removed for VLAN %s on device %s interface %s.";
    private static final String REMOVE_TRUNK_FAILURE = "Failed to remove trunk mode for VLAN %s on device %s interface %s.";
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    private String uri = null;
    @Argument(index=1, name="interface", description="Interface name", required=true, multiValued=false)
    private String portName = null;
    @Argument(index=2, name="vlan", description="VLAN ID", required=true, multiValued=false)
    private String vlanString = null;
    @Option(name="-t", aliases={"--trunk"}, description="Remove trunk mode for VLAN", required=false, multiValued=false)
    private boolean trunkMode = false;

    @Override
    protected void execute() {
        DriverService service = DeviceInterfaceRemoveCommand.get(DriverService.class);
        DeviceId deviceId = DeviceId.deviceId((String)this.uri);
        DriverHandler h = service.createHandler(deviceId, new String[0]);
        InterfaceConfig interfaceConfig = (InterfaceConfig)h.behaviour(InterfaceConfig.class);
        VlanId vlanId = VlanId.vlanId((short)Short.parseShort(this.vlanString));
        if (this.trunkMode) {
            if (interfaceConfig.removeTrunkInterface(deviceId, this.portName, vlanId)) {
                this.print(REMOVE_TRUNK_SUCCESS, vlanId, deviceId, this.portName);
            } else {
                this.print(REMOVE_TRUNK_FAILURE, vlanId, deviceId, this.portName);
            }
            return;
        }
        if (interfaceConfig.removeInterfaceFromVlan(deviceId, this.portName, vlanId)) {
            this.print(REMOVE_VLAN_SUCCESS, vlanId, deviceId, this.portName);
        } else {
            this.print(REMOVE_VLAN_FAILURE, vlanId, deviceId, this.portName);
        }
    }
}

