/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.net.DevicesListCommand;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortStatistics;

@Command(scope="onos", name="portstats", description="Lists statistics of all ports in the system")
public class DevicePortStatsCommand
extends DevicesListCommand {
    @Option(name="-d", aliases={"--delta"}, description="Show Delta Port Statistics,only for the last polling interval", required=false, multiValued=false)
    private boolean delta = false;
    @Option(name="-t", aliases={"--table"}, description="Show human readable table format for statistics", required=false, multiValued=false)
    private boolean table = false;
    @Argument(index=0, name="uri", description="Device ID", required=false, multiValued=false)
    String uri = null;
    private static final String FORMAT = "   port=%s, pktRx=%s, pktTx=%s, bytesRx=%s, bytesTx=%s, pktRxDrp=%s, pktTxDrp=%s, Dur=%s";

    @Override
    protected void execute() {
        DeviceService deviceService = DevicePortStatsCommand.get(DeviceService.class);
        if (this.uri == null) {
            for (Device d : DevicePortStatsCommand.getSortedDevices(deviceService)) {
                if (this.delta) {
                    if (this.table) {
                        this.printPortStatsDeltaTable(d.id(), deviceService.getPortDeltaStatistics(d.id()));
                        continue;
                    }
                    this.printPortStatsDelta(d.id(), deviceService.getPortDeltaStatistics(d.id()));
                    continue;
                }
                this.printPortStats(d.id(), deviceService.getPortStatistics(d.id()));
            }
        } else {
            Device d = deviceService.getDevice(DeviceId.deviceId((String)this.uri));
            if (d == null) {
                this.error("No such device %s", this.uri);
            } else if (this.delta) {
                if (this.table) {
                    this.printPortStatsDeltaTable(d.id(), deviceService.getPortDeltaStatistics(d.id()));
                } else {
                    this.printPortStatsDelta(d.id(), deviceService.getPortDeltaStatistics(d.id()));
                }
            } else {
                this.printPortStats(d.id(), deviceService.getPortStatistics(d.id()));
            }
        }
    }

    private void printPortStats(DeviceId deviceId, Iterable<PortStatistics> portStats) {
        this.print("deviceId=%s", deviceId);
        for (PortStatistics stat : DevicePortStatsCommand.sortByPort(portStats)) {
            this.print(FORMAT, stat.port(), stat.packetsReceived(), stat.packetsSent(), stat.bytesReceived(), stat.bytesSent(), stat.packetsRxDropped(), stat.packetsTxDropped(), stat.durationSec());
        }
    }

    private void printPortStatsDelta(DeviceId deviceId, Iterable<PortStatistics> portStats) {
        String formatDelta = "   port=%s, pktRx=%s, pktTx=%s, bytesRx=%s, bytesTx=%s, rateRx=%s, rateTx=%s, pktRxDrp=%s, pktTxDrp=%s, interval=%s";
        this.print("deviceId=%s", deviceId);
        for (PortStatistics stat : DevicePortStatsCommand.sortByPort(portStats)) {
            float duration = (float)stat.durationSec() + (float)stat.durationNano() / (float)TimeUnit.SECONDS.toNanos(1L);
            float rateRx = (float)(stat.bytesReceived() * 8L) / duration;
            float rateTx = (float)(stat.bytesSent() * 8L) / duration;
            this.print("   port=%s, pktRx=%s, pktTx=%s, bytesRx=%s, bytesTx=%s, rateRx=%s, rateTx=%s, pktRxDrp=%s, pktTxDrp=%s, interval=%s", stat.port(), stat.packetsReceived(), stat.packetsSent(), stat.bytesReceived(), stat.bytesSent(), String.format("%.1f", Float.valueOf(rateRx)), String.format("%.1f", Float.valueOf(rateTx)), stat.packetsRxDropped(), stat.packetsTxDropped(), String.format("%.3f", Float.valueOf(duration)));
        }
    }

    private void printPortStatsDeltaTable(DeviceId deviceId, Iterable<PortStatistics> portStats) {
        String formatDeltaTable = "|%5s | %7s | %7s |  %7s | %7s | %7s | %7s |  %7s | %7s |%9s |";
        this.print("+---------------------------------------------------------------------------------------------------+", new Object[0]);
        this.print("| DeviceId = %s                                                                    |", deviceId);
        this.print("|---------------------------------------------------------------------------------------------------|", new Object[0]);
        this.print("|      | Receive                                | Transmit                               | Time [s] |", new Object[0]);
        this.print("| Port | Packets |  Bytes  | Rate bps |   Drop  | Packets |  Bytes  | Rate bps |   Drop  | Interval |", new Object[0]);
        this.print("|---------------------------------------------------------------------------------------------------|", new Object[0]);
        for (PortStatistics stat : DevicePortStatsCommand.sortByPort(portStats)) {
            float duration = (float)stat.durationSec() + (float)stat.durationNano() / (float)TimeUnit.SECONDS.toNanos(1L);
            float rateRx = (float)(stat.bytesReceived() * 8L) / duration;
            float rateTx = (float)(stat.bytesSent() * 8L) / duration;
            this.print("|%5s | %7s | %7s |  %7s | %7s | %7s | %7s |  %7s | %7s |%9s |", stat.port(), DevicePortStatsCommand.humanReadable(stat.packetsReceived()), DevicePortStatsCommand.humanReadable(stat.bytesReceived()), DevicePortStatsCommand.humanReadableBps(rateRx), DevicePortStatsCommand.humanReadable(stat.packetsRxDropped()), DevicePortStatsCommand.humanReadable(stat.packetsSent()), DevicePortStatsCommand.humanReadable(stat.bytesSent()), DevicePortStatsCommand.humanReadableBps(rateTx), DevicePortStatsCommand.humanReadable(stat.packetsTxDropped()), String.format("%.3f", Float.valueOf(duration)));
        }
        this.print("+---------------------------------------------------------------------------------------------------+", new Object[0]);
    }

    public static String humanReadable(long bytes) {
        int unit = 1000;
        if (bytes < (long)unit) {
            return String.format("%s ", bytes);
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        Character pre = Character.valueOf("KMGTPE".charAt(exp - 1));
        return String.format("%.2f%s", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String humanReadableBps(float bps) {
        int unit = 1000;
        if (bps < (float)unit) {
            return String.format("%.0f ", Float.valueOf(bps));
        }
        int exp = (int)(Math.log(bps) / Math.log(unit));
        Character pre = Character.valueOf("KMGTPE".charAt(exp - 1));
        return String.format("%.2f%s", (double)bps / Math.pow(unit, exp), pre);
    }

    private static List<PortStatistics> sortByPort(Iterable<PortStatistics> portStats) {
        ArrayList portStatsList = Lists.newArrayList(portStats);
        portStatsList.sort((o1, o2) -> o1.port() - o2.port());
        return portStatsList;
    }
}

