/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.intent.OpticalCircuitIntent;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.intent.PathIntent;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;

@Command(scope="onos", name="intents", description="Lists the inventory of intents and their states")
public class IntentsListCommand
extends AbstractShellCommand {
    @Option(name="-i", aliases={"--installable"}, description="Output Installable Intents", required=false, multiValued=false)
    private boolean showInstallable = false;
    @Option(name="-s", aliases={"--summary"}, description="Intents summary", required=false, multiValued=false)
    private boolean intentsSummary = false;
    @Option(name="-p", aliases={"--pending"}, description="Show inforamtion about pending intents", required=false, multiValued=false)
    private boolean pending = false;

    @Override
    protected void execute() {
        IntentService service = IntentsListCommand.get(IntentService.class);
        if (this.intentsSummary) {
            IntentSummaries intentSummaries = new IntentSummaries();
            intentSummaries.collectIntentSummary(service, service.getIntents());
            if (this.outputJson()) {
                this.print("%s", intentSummaries.json());
            } else {
                intentSummaries.printSummary();
            }
            return;
        }
        if (this.pending) {
            if (this.outputJson()) {
                this.print("%s", this.json(service, service.getPending()));
            } else {
                service.getPending().forEach(intent -> this.print("id=%s, key=%s, type=%s, appId=%s", intent.id(), intent.key(), intent.getClass().getSimpleName(), intent.appId().name()));
            }
            return;
        }
        if (this.outputJson()) {
            this.print("%s", this.json(service, service.getIntents()));
        } else {
            for (Intent intent2 : service.getIntents()) {
                IntentState state = service.getIntentState(intent2.key());
                if (state == null) continue;
                this.print("id=%s, state=%s, key=%s, type=%s, appId=%s", intent2.id(), state, intent2.key(), intent2.getClass().getSimpleName(), intent2.appId().name());
                this.printDetails(service, intent2);
            }
        }
    }

    private void printDetails(IntentService service, Intent intent) {
        HostToHostIntent pi;
        ConnectivityIntent ci;
        if (!intent.resources().isEmpty()) {
            this.print("    resources=%s", intent.resources());
        }
        if (intent instanceof ConnectivityIntent) {
            ci = (ConnectivityIntent)intent;
            if (!ci.selector().criteria().isEmpty()) {
                this.print("    selector=%s", ci.selector().criteria());
            }
            if (!ci.treatment().allInstructions().isEmpty()) {
                this.print("    treatment=%s", ci.treatment().allInstructions());
            }
            if (ci.constraints() != null && !ci.constraints().isEmpty()) {
                this.print("    constraints=%s", ci.constraints());
            }
        }
        if (intent instanceof HostToHostIntent) {
            pi = (HostToHostIntent)intent;
            this.print("    host1=%s, host2=%s", pi.one(), pi.two());
        } else if (intent instanceof PointToPointIntent) {
            pi = (PointToPointIntent)intent;
            this.print("    ingress=%s, egress=%s", pi.ingressPoint(), pi.egressPoint());
        } else if (intent instanceof MultiPointToSinglePointIntent) {
            pi = (MultiPointToSinglePointIntent)intent;
            this.print("    ingress=%s, egress=%s", pi.ingressPoints(), pi.egressPoint());
        } else if (intent instanceof SinglePointToMultiPointIntent) {
            pi = (SinglePointToMultiPointIntent)intent;
            this.print("    ingress=%s, egress=%s", pi.ingressPoint(), pi.egressPoints());
        } else if (intent instanceof PathIntent) {
            pi = (PathIntent)intent;
            this.print("    path=%s, cost=%d", pi.path().links(), pi.path().cost());
        } else if (intent instanceof LinkCollectionIntent) {
            LinkCollectionIntent li = (LinkCollectionIntent)intent;
            this.print("    links=%s", li.links());
            this.print("    egress=%s", li.egressPoints());
        } else if (intent instanceof OpticalCircuitIntent) {
            ci = (OpticalCircuitIntent)intent;
            this.print("    src=%s, dst=%s", ci.getSrc(), ci.getDst());
        } else if (intent instanceof OpticalConnectivityIntent) {
            ci = (OpticalConnectivityIntent)intent;
            this.print("    src=%s, dst=%s", ci.getSrc(), ci.getDst());
        }
        List installable = service.getInstallableIntents(intent.key());
        if (this.showInstallable && installable != null && !installable.isEmpty()) {
            this.print("    installable=%s", installable);
        }
    }

    private JsonNode json(IntentService service, Iterable<Intent> intents) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        intents.forEach(intent -> result.add((JsonNode)this.jsonForEntity(intent, Intent.class)));
        return result;
    }

    private class IntentSummaries {
        private IntentSummary summaryAll;
        private IntentSummary summaryConnectivity;
        private IntentSummary summaryHostToHost;
        private IntentSummary summaryPointToPoint;
        private IntentSummary summaryMultiPointToSinglePoint;
        private IntentSummary summarySinglePointToMultiPoint;
        private IntentSummary summaryPath;
        private IntentSummary summaryLinkCollection;
        private IntentSummary summaryOpticalCircuit;
        private IntentSummary summaryOpticalConnectivity;
        private IntentSummary summaryUnknownType;

        private IntentSummaries() {
        }

        private void init() {
            this.summaryAll = new IntentSummary("All");
            this.summaryConnectivity = new IntentSummary("Connectivity");
            this.summaryHostToHost = new IntentSummary("HostToHost");
            this.summaryPointToPoint = new IntentSummary("PointToPoint");
            this.summaryMultiPointToSinglePoint = new IntentSummary("MultiPointToSinglePoint");
            this.summarySinglePointToMultiPoint = new IntentSummary("SinglePointToMultiPoint");
            this.summaryPath = new IntentSummary("Path");
            this.summaryLinkCollection = new IntentSummary("LinkCollection");
            this.summaryOpticalCircuit = new IntentSummary("OpticalCircuit");
            this.summaryOpticalConnectivity = new IntentSummary("OpticalConnectivity");
            this.summaryUnknownType = new IntentSummary("UnknownType");
        }

        private void collectIntentSummary(IntentService service, Iterable<Intent> intents) {
            this.init();
            for (Intent intent : intents) {
                IntentState intentState = service.getIntentState(intent.key());
                if (intentState == null) continue;
                this.summaryAll.update(intentState);
                if (intent instanceof ConnectivityIntent) {
                    this.summaryConnectivity.update(intentState);
                }
                if (intent instanceof HostToHostIntent) {
                    this.summaryHostToHost.update(intentState);
                    continue;
                }
                if (intent instanceof PointToPointIntent) {
                    this.summaryPointToPoint.update(intentState);
                    continue;
                }
                if (intent instanceof MultiPointToSinglePointIntent) {
                    this.summaryMultiPointToSinglePoint.update(intentState);
                    continue;
                }
                if (intent instanceof SinglePointToMultiPointIntent) {
                    this.summarySinglePointToMultiPoint.update(intentState);
                    continue;
                }
                if (intent instanceof PathIntent) {
                    this.summaryPath.update(intentState);
                    continue;
                }
                if (intent instanceof LinkCollectionIntent) {
                    this.summaryLinkCollection.update(intentState);
                    continue;
                }
                if (intent instanceof OpticalCircuitIntent) {
                    this.summaryOpticalCircuit.update(intentState);
                    continue;
                }
                if (intent instanceof OpticalConnectivityIntent) {
                    this.summaryOpticalConnectivity.update(intentState);
                    continue;
                }
                this.summaryUnknownType.update(intentState);
            }
        }

        ObjectNode json() {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode result = mapper.createObjectNode();
            result.set("connectivity", this.summaryConnectivity.json(mapper));
            result.set("hostToHost", this.summaryHostToHost.json(mapper));
            result.set("pointToPoint", this.summaryPointToPoint.json(mapper));
            result.set("multiPointToSinglePoint", this.summaryMultiPointToSinglePoint.json(mapper));
            result.set("singlePointToMultiPoint", this.summarySinglePointToMultiPoint.json(mapper));
            result.set("path", this.summaryPath.json(mapper));
            result.set("linkCollection", this.summaryLinkCollection.json(mapper));
            result.set("opticalCircuit", this.summaryOpticalCircuit.json(mapper));
            result.set("opticalConnectivity", this.summaryOpticalConnectivity.json(mapper));
            result.set("unknownType", this.summaryUnknownType.json(mapper));
            result.set("all", this.summaryAll.json(mapper));
            return result;
        }

        private void printSummary() {
            this.summaryConnectivity.printState();
            this.summaryHostToHost.printState();
            this.summaryPointToPoint.printState();
            this.summaryMultiPointToSinglePoint.printState();
            this.summarySinglePointToMultiPoint.printState();
            this.summaryPath.printState();
            this.summaryLinkCollection.printState();
            this.summaryOpticalCircuit.printState();
            this.summaryOpticalConnectivity.printState();
            this.summaryUnknownType.printState();
            this.summaryAll.printState();
        }

        private class IntentSummary {
            private final String intentType;
            private int total = 0;
            private int installReq = 0;
            private int compiling = 0;
            private int installing = 0;
            private int installed = 0;
            private int recompiling = 0;
            private int withdrawReq = 0;
            private int withdrawing = 0;
            private int withdrawn = 0;
            private int failed = 0;
            private int unknownState = 0;
            private static final String FORMAT_SUMMARY_LINE1 = "%-23s    total=        %7d   installed=   %7d";
            private static final String FORMAT_SUMMARY_LINE2 = "%-23s    withdrawn=    %7d   failed=      %7d";
            private static final String FORMAT_SUMMARY_LINE3 = "%-23s    installReq=   %7d   compiling=   %7d";
            private static final String FORMAT_SUMMARY_LINE4 = "%-23s    installing=   %7d   recompiling= %7d";
            private static final String FORMAT_SUMMARY_LINE5 = "%-23s    withdrawReq=  %7d   withdrawing= %7d";
            private static final String FORMAT_SUMMARY_LINE6 = "%-23s    unknownState= %7d";

            IntentSummary(String intentType) {
                this.intentType = intentType;
            }

            void update(IntentState intentState) {
                ++this.total;
                switch (intentState) {
                    case INSTALL_REQ: {
                        ++this.installReq;
                        break;
                    }
                    case COMPILING: {
                        ++this.compiling;
                        break;
                    }
                    case INSTALLING: {
                        ++this.installing;
                        break;
                    }
                    case INSTALLED: {
                        ++this.installed;
                        break;
                    }
                    case RECOMPILING: {
                        ++this.recompiling;
                        break;
                    }
                    case WITHDRAW_REQ: {
                        ++this.withdrawReq;
                        break;
                    }
                    case WITHDRAWING: {
                        ++this.withdrawing;
                        break;
                    }
                    case WITHDRAWN: {
                        ++this.withdrawn;
                        break;
                    }
                    case FAILED: {
                        ++this.failed;
                        break;
                    }
                    default: {
                        ++this.unknownState;
                    }
                }
            }

            void printState() {
                IntentsListCommand.this.print(FORMAT_SUMMARY_LINE1, this.intentType, this.total, this.installed);
                IntentsListCommand.this.print(FORMAT_SUMMARY_LINE2, this.intentType, this.withdrawn, this.failed);
                IntentsListCommand.this.print(FORMAT_SUMMARY_LINE3, this.intentType, this.installReq, this.compiling);
                IntentsListCommand.this.print(FORMAT_SUMMARY_LINE4, this.intentType, this.installing, this.recompiling);
                IntentsListCommand.this.print(FORMAT_SUMMARY_LINE5, this.intentType, this.withdrawReq, this.withdrawing);
                if (this.unknownState != 0) {
                    IntentsListCommand.this.print(FORMAT_SUMMARY_LINE6, this.intentType, this.unknownState);
                }
            }

            JsonNode json(ObjectMapper mapper) {
                ObjectNode result = mapper.createObjectNode().put("total", this.total).put("installed", this.installed).put("failed", this.failed).put("installReq", this.installReq).put("compiling", this.compiling).put("installing", this.installing).put("recompiling", this.recompiling).put("withdrawReq", this.withdrawReq).put("withdrawing", this.withdrawing).put("withdrawn", this.withdrawn).put("unknownState", this.unknownState);
                return result;
            }
        }
    }
}

