/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.util.Frequency;
import org.onosproject.cli.net.DevicesListCommand;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.OchPort;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.optical.OduCltPort;
import org.onosproject.net.optical.OmsPort;
import org.onosproject.net.optical.OpticalDevice;
import org.onosproject.net.optical.OtuPort;
import org.onosproject.net.optical.device.OpticalDeviceServiceView;
import org.onosproject.utils.Comparators;

@Command(scope="onos", name="ports", description="Lists all ports or all ports of a device")
public class DevicePortsListCommand
extends DevicesListCommand {
    private static final String FMT = "  port=%s, state=%s, type=%s, speed=%s %s";
    private static final String FMT_OCH = "  port=%s, state=%s, type=%s, signalType=%s, isTunable=%s %s";
    private static final String FMT_ODUCLT_OTU = "  port=%s, state=%s, type=%s, signalType=%s %s";
    private static final String FMT_OMS = "  port=%s, state=%s, type=%s, Freqs= %s / %s / %s GHz, totalChannels=%s %s";
    @Option(name="-e", aliases={"--enabled"}, description="Show only enabled ports", required=false, multiValued=false)
    private boolean enabled = false;
    @Option(name="-d", aliases={"--disabled"}, description="Show only disabled ports", required=false, multiValued=false)
    private boolean disabled = false;
    @Argument(index=0, name="uri", description="Device ID", required=false, multiValued=false)
    String uri = null;

    @Override
    protected void execute() {
        OpticalDeviceServiceView service = OpticalDeviceServiceView.opticalView((DeviceService)DevicePortsListCommand.get(DeviceService.class));
        if (this.uri == null) {
            if (this.outputJson()) {
                this.print("%s", this.jsonPorts((DeviceService)service, DevicePortsListCommand.getSortedDevices((DeviceService)service)));
            } else {
                for (Device device : DevicePortsListCommand.getSortedDevices((DeviceService)service)) {
                    this.printDevice((DeviceService)service, device);
                }
            }
        } else {
            Device device = service.getDevice(DeviceId.deviceId((String)this.uri));
            if (device == null) {
                this.error("No such device %s", this.uri);
            } else if (this.outputJson()) {
                this.print("%s", this.jsonPorts((DeviceService)service, new ObjectMapper(), device));
            } else {
                this.printDevice((DeviceService)service, device);
            }
        }
    }

    public JsonNode jsonPorts(DeviceService service, Iterable<Device> devices) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Device device : devices) {
            result.add(this.jsonPorts(service, mapper, device));
        }
        return result;
    }

    public JsonNode jsonPorts(DeviceService service, ObjectMapper mapper, Device device) {
        ObjectNode result = mapper.createObjectNode();
        ArrayNode ports = mapper.createArrayNode();
        for (Port port : service.getPorts(device.id())) {
            if (!this.isIncluded(port)) continue;
            ports.add(mapper.createObjectNode().put("port", this.portName(port.number())).put("isEnabled", port.isEnabled()).put("type", port.type().toString().toLowerCase()).put("portSpeed", port.portSpeed()).set("annotations", (JsonNode)DevicePortsListCommand.annotations(mapper, port.annotations())));
        }
        result.set("device", (JsonNode)this.jsonForEntity(device, Device.class));
        result.set("ports", (JsonNode)ports);
        return result;
    }

    private String portName(PortNumber port) {
        return port.equals((Object)PortNumber.LOCAL) ? "local" : port.toString();
    }

    private boolean isIncluded(Port port) {
        return this.enabled && port.isEnabled() || this.disabled && !port.isEnabled() || !this.enabled && !this.disabled;
    }

    @Override
    protected void printDevice(DeviceService service, Device device) {
        super.printDevice(service, device);
        ArrayList ports = new ArrayList(service.getPorts(device.id()));
        Collections.sort(ports, Comparators.PORT_COMPARATOR);
        block6: for (Port port : ports) {
            if (!this.isIncluded(port)) continue;
            String portName = this.portName(port.number());
            String portIsEnabled = port.isEnabled() ? "enabled" : "disabled";
            String portType = port.type().toString().toLowerCase();
            String annotations = DevicePortsListCommand.annotations(port.annotations());
            switch (port.type()) {
                case OCH: {
                    OpticalDevice optDevice;
                    OchPort oPort;
                    if (port instanceof OchPort) {
                        oPort = (OchPort)port;
                        this.print("WARN: OchPort in old model", new Object[0]);
                        this.print(FMT_OCH, portName, portIsEnabled, portType, oPort.signalType().toString(), oPort.isTunable() ? "yes" : "no", annotations);
                        continue block6;
                    }
                    if (port instanceof org.onosproject.net.optical.OchPort) {
                        org.onosproject.net.optical.OchPort och = (org.onosproject.net.optical.OchPort)port;
                        this.print(FMT_OCH, portName, portIsEnabled, portType, och.signalType().toString(), och.isTunable() ? "yes" : "no", annotations);
                        continue block6;
                    }
                    if (port.element().is(OpticalDevice.class) && (optDevice = (OpticalDevice)port.element().as(OpticalDevice.class)).portIs(port, org.onosproject.net.optical.OchPort.class)) {
                        org.onosproject.net.optical.OchPort och = (org.onosproject.net.optical.OchPort)optDevice.portAs(port, org.onosproject.net.optical.OchPort.class).get();
                        this.print(FMT_OCH, portName, portIsEnabled, portType, och.signalType().toString(), och.isTunable() ? "yes" : "no", annotations);
                        continue block6;
                    }
                    this.print("WARN: OchPort but not on OpticalDevice or ill-formed", new Object[0]);
                    this.print(FMT, portName, portIsEnabled, portType, port.portSpeed(), annotations);
                    continue block6;
                }
                case ODUCLT: {
                    OchPort oPort;
                    if (port instanceof org.onosproject.net.OduCltPort) {
                        oPort = (org.onosproject.net.OduCltPort)port;
                        this.print("WARN: OduCltPort in old model", new Object[0]);
                        this.print(FMT_ODUCLT_OTU, portName, portIsEnabled, portType, oPort.signalType().toString(), annotations);
                        continue block6;
                    }
                    if (port instanceof OduCltPort) {
                        this.print(FMT_ODUCLT_OTU, portName, portIsEnabled, portType, ((OduCltPort)port).signalType().toString(), annotations);
                        continue block6;
                    }
                    this.print("WARN: OduCltPort but not on OpticalDevice or ill-formed", new Object[0]);
                    this.print(FMT, portName, portIsEnabled, portType, port.portSpeed(), annotations);
                    continue block6;
                }
                case OMS: {
                    org.onosproject.net.OmsPort oms;
                    if (port instanceof org.onosproject.net.OmsPort) {
                        oms = (org.onosproject.net.OmsPort)port;
                        this.print("WARN: OmsPort in old model", new Object[0]);
                        this.print(FMT_OMS, portName, portIsEnabled, portType, oms.minFrequency().asHz() / Frequency.ofGHz((long)1L).asHz(), oms.maxFrequency().asHz() / Frequency.ofGHz((long)1L).asHz(), oms.grid().asHz() / Frequency.ofGHz((long)1L).asHz(), oms.totalChannels(), annotations);
                        continue block6;
                    }
                    if (port instanceof OmsPort) {
                        oms = (OmsPort)port;
                        this.print(FMT_OMS, portName, portIsEnabled, portType, oms.minFrequency().asHz() / Frequency.ofGHz((long)1L).asHz(), oms.maxFrequency().asHz() / Frequency.ofGHz((long)1L).asHz(), oms.grid().asHz() / Frequency.ofGHz((long)1L).asHz(), oms.totalChannels(), annotations);
                        continue block6;
                    }
                    this.print("WARN: OmsPort but not on OpticalDevice or ill-formed", new Object[0]);
                    this.print(FMT, portName, portIsEnabled, portType, port.portSpeed(), annotations);
                    continue block6;
                }
                case OTU: {
                    if (port instanceof org.onosproject.net.OtuPort) {
                        org.onosproject.net.OtuPort otu = (org.onosproject.net.OtuPort)port;
                        this.print("WARN: OtuPort in old model", new Object[0]);
                        this.print(FMT_ODUCLT_OTU, portName, portIsEnabled, portType, otu.signalType().toString(), annotations);
                        continue block6;
                    }
                    if (port instanceof OtuPort) {
                        this.print(FMT_ODUCLT_OTU, portName, portIsEnabled, portType, ((OtuPort)port).signalType().toString(), annotations);
                        continue block6;
                    }
                    this.print("WARN: OtuPort but not on OpticalDevice or ill-formed", new Object[0]);
                    this.print(FMT, portName, portIsEnabled, portType, port.portSpeed(), annotations);
                    continue block6;
                }
            }
            this.print(FMT, portName, portIsEnabled, portType, port.portSpeed(), annotations);
        }
    }
}

