/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.ControllerConfig;
import org.onosproject.net.behaviour.ControllerInfo;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;

@Command(scope="onos", name="device-setcontrollers", description="sets the list of controllers for the given infrastructure device")
public class DeviceSetControllersCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    String uri = null;
    @Argument(index=1, name="controllersListStrings", description="list of controllers to set for the specified device", required=true, multiValued=true)
    String[] controllersListStrings = null;
    private DeviceId deviceId;
    private List<ControllerInfo> newControllers = new ArrayList<ControllerInfo>();

    @Override
    protected void execute() {
        Arrays.asList(this.controllersListStrings).forEach(cInfoString -> this.newControllers.add(new ControllerInfo(cInfoString)));
        DriverService service = DeviceSetControllersCommand.get(DriverService.class);
        this.deviceId = DeviceId.deviceId((String)this.uri);
        DriverHandler h = service.createHandler(this.deviceId, new String[0]);
        ControllerConfig config = (ControllerConfig)h.behaviour(ControllerConfig.class);
        this.print("before:", new Object[0]);
        config.getControllers().forEach(c -> this.print(c.target(), new Object[0]));
        try {
            config.setControllers(this.newControllers);
        }
        catch (NullPointerException e) {
            this.print("No Device with requested parameters {} ", this.uri);
        }
        this.print("after:", new Object[0]);
        config.getControllers().forEach(c -> this.print(c.target(), new Object[0]));
        this.print("size %d", config.getControllers().size());
    }
}

