/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.utils.Comparators;

@Command(scope="onos", name="flows", description="Lists all currently-known flows.")
public class FlowsListCommand
extends AbstractShellCommand {
    private static final Predicate<FlowEntry> TRUE_PREDICATE = f -> true;
    public static final String ANY = "any";
    private static final String LONG_FORMAT = "    id=%s, state=%s, bytes=%s, packets=%s, duration=%s, priority=%s, tableId=%s, appId=%s, payLoad=%s, selector=%s, treatment=%s";
    private static final String SHORT_FORMAT = "    %s, bytes=%s, packets=%s, table=%s, priority=%s, selector=%s, treatment=%s";
    @Argument(index=0, name="state", description="Flow Rule state", required=false, multiValued=false)
    String state = null;
    @Argument(index=1, name="uri", description="Device ID", required=false, multiValued=false)
    String uri = null;
    @Argument(index=2, name="table", description="Table ID", required=false, multiValued=false)
    String table = null;
    @Option(name="-s", aliases={"--short"}, description="Print more succinct output for each flow", required=false, multiValued=false)
    private boolean shortOutput = false;
    @Option(name="-n", aliases={"--no-core-flows"}, description="Suppress core flows from output", required=false, multiValued=false)
    private boolean suppressCoreOutput = false;
    @Option(name="-c", aliases={"--count"}, description="Print flow count only", required=false, multiValued=false)
    private boolean countOnly = false;
    private Predicate<FlowEntry> predicate = TRUE_PREDICATE;

    @Override
    protected void execute() {
        CoreService coreService = FlowsListCommand.get(CoreService.class);
        DeviceService deviceService = FlowsListCommand.get(DeviceService.class);
        FlowRuleService service = FlowsListCommand.get(FlowRuleService.class);
        this.compilePredicate();
        SortedMap<Device, List<FlowEntry>> flows = this.getSortedFlows(deviceService, service, coreService);
        if (this.outputJson()) {
            this.print("%s", this.json(flows.keySet(), flows));
        } else {
            flows.forEach((device, flow) -> this.printFlows((Device)device, (List<FlowEntry>)flow, coreService));
        }
    }

    private JsonNode json(Iterable<Device> devices, Map<Device, List<FlowEntry>> flows) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Device device : devices) {
            result.add((JsonNode)this.json(mapper, device, flows.get(device)));
        }
        return result;
    }

    private void compilePredicate() {
        if (this.state != null && !this.state.equals(ANY)) {
            FlowEntry.FlowEntryState feState = FlowEntry.FlowEntryState.valueOf((String)this.state.toUpperCase());
            this.predicate = this.predicate.and(f -> f.state().equals((Object)feState));
        }
        if (this.table != null) {
            int tableId = Integer.parseInt(this.table);
            this.predicate = this.predicate.and(f -> f.tableId() == tableId);
        }
    }

    private ObjectNode json(ObjectMapper mapper, Device device, List<FlowEntry> flows) {
        ObjectNode result = mapper.createObjectNode();
        ArrayNode array = mapper.createArrayNode();
        flows.forEach(flow -> array.add((JsonNode)this.jsonForEntity(flow, FlowEntry.class)));
        result.put("device", device.id().toString()).put("flowCount", flows.size()).set("flows", (JsonNode)array);
        return result;
    }

    protected SortedMap<Device, List<FlowEntry>> getSortedFlows(DeviceService deviceService, FlowRuleService service, CoreService coreService) {
        Device dev;
        TreeMap<Device, List<FlowEntry>> flows = new TreeMap<Device, List<FlowEntry>>(Comparators.ELEMENT_COMPARATOR);
        List<Device> devices = null;
        devices = this.uri == null ? deviceService.getDevices() : ((dev = deviceService.getDevice(DeviceId.deviceId((String)this.uri))) == null ? deviceService.getDevices() : Collections.singletonList(dev));
        for (Device d : devices) {
            List<Object> rules;
            if (this.predicate.equals(TRUE_PREDICATE)) {
                rules = Lists.newArrayList((Iterable)service.getFlowEntries(d.id()));
            } else {
                rules = Lists.newArrayList();
                for (FlowEntry f2 : service.getFlowEntries(d.id())) {
                    if (!this.predicate.test(f2)) continue;
                    rules.add(f2);
                }
            }
            rules.sort(Comparators.FLOW_RULE_COMPARATOR);
            if (this.suppressCoreOutput) {
                short coreAppId = coreService.getAppId("org.onosproject.core").id();
                rules = rules.stream().filter(f -> f.appId() != coreAppId).collect(Collectors.toList());
            }
            flows.put(d, rules);
        }
        return flows;
    }

    protected void printFlows(Device d, List<FlowEntry> flows, CoreService coreService) {
        boolean empty = flows == null || flows.isEmpty();
        this.print("deviceId=%s, flowRuleCount=%d", d.id(), empty ? 0 : flows.size());
        if (empty || this.countOnly) {
            return;
        }
        for (FlowEntry f : flows) {
            if (this.shortOutput) {
                this.print(SHORT_FORMAT, f.state(), f.bytes(), f.packets(), f.tableId(), f.priority(), f.selector().criteria(), this.printTreatment(f.treatment()));
                continue;
            }
            ApplicationId appId = coreService.getAppId(Short.valueOf(f.appId()));
            this.print(LONG_FORMAT, Long.toHexString(f.id().value()), f.state(), f.bytes(), f.packets(), f.life(), f.priority(), f.tableId(), appId != null ? appId.name() : "<none>", f.payLoad() == null ? null : f.payLoad().payLoad().toString(), f.selector().criteria(), f.treatment());
        }
    }

    private String printTreatment(TrafficTreatment treatment) {
        String delimiter = ", ";
        StringBuilder builder = new StringBuilder("[");
        if (!treatment.immediate().isEmpty()) {
            builder.append("immediate=" + treatment.immediate() + ", ");
        }
        if (!treatment.deferred().isEmpty()) {
            builder.append("deferred=" + treatment.deferred() + ", ");
        }
        if (treatment.clearedDeferred()) {
            builder.append("clearDeferred, ");
        }
        if (treatment.tableTransition() != null) {
            builder.append("transition=" + treatment.tableTransition() + ", ");
        }
        if (treatment.metered() != null) {
            builder.append("meter=" + treatment.metered() + ", ");
        }
        if (treatment.writeMetadata() != null) {
            builder.append("metadata=" + treatment.writeMetadata() + ", ");
        }
        builder.replace(builder.length() - ", ".length(), builder.length(), "");
        builder.append("]");
        return builder.toString();
    }
}

