/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.Collection;
import java.util.Set;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.routing.RouteService;

@Command(scope="onos", name="next-hops", description="Lists all next hops in the route store")
public class NextHopsListCommand
extends AbstractShellCommand {
    private static final String FORMAT_HEADER = "   Network            Next Hop";
    private static final String FORMAT_ROUTE = "   %-18s %-15s";
    private static final String FORMAT_TABLE = "Table: %s";
    private static final String FORMAT_TOTAL = "   Total: %d";
    private static final String FORMAT = "ip=%s, mac=%s, numRoutes=%s";

    @Override
    protected void execute() {
        RouteService service = AbstractShellCommand.get(RouteService.class);
        Set nextHops = service.getNextHops();
        nextHops.forEach(nextHop -> {
            Collection routes = service.getRoutesForNextHop(nextHop.ip());
            this.print(FORMAT, nextHop.ip(), nextHop.mac(), routes.size());
        });
    }
}

