/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.region.RegionAdminService;
import org.onosproject.net.region.RegionId;

@Command(scope="onos", name="region-add-devices", description="Adds a set of devices into the region.")
public class RegionAddDevicesCommand
extends AbstractShellCommand {
    @Argument(index=0, name="id", description="Region ID", required=true, multiValued=false)
    String id = null;
    @Argument(index=1, name="devIds", description="Device IDs", required=true, multiValued=true)
    List<String> devIds = null;

    @Override
    protected void execute() {
        RegionAdminService service = RegionAddDevicesCommand.get(RegionAdminService.class);
        RegionId regionId = RegionId.regionId((String)this.id);
        List dids = this.devIds.stream().map(s -> DeviceId.deviceId((String)s)).collect(Collectors.toList());
        service.addDevices(regionId, dids);
    }
}

