/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.net.ClustersListCommand;
import org.onosproject.net.Device;
import org.onosproject.net.Host;
import org.onosproject.net.Link;
import org.onosproject.net.device.DeviceAdminService;
import org.onosproject.net.host.HostAdminService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.link.LinkAdminService;

@Command(scope="onos", name="wipe-out", description="Wipes-out the entire network information base, i.e. devices, links, hosts")
public class WipeOutCommand
extends ClustersListCommand {
    private static final String PLEASE = "please";
    @Argument(index=0, name="please", description="Confirmation phrase", required=false, multiValued=false)
    String please = null;

    @Override
    protected void execute() {
        if (this.please == null || !this.please.equals(PLEASE)) {
            this.print("I'm afraid I can't do that!\nSay: %s", PLEASE);
            return;
        }
        this.wipeOutIntents();
        this.wipeOutHosts();
        this.wipeOutDevices();
        this.wipeOutLinks();
    }

    private void wipeOutIntents() {
        this.print("Wiping intents", new Object[0]);
        IntentService intentService = WipeOutCommand.get(IntentService.class);
        for (Intent intent : intentService.getIntents()) {
            if (intentService.getIntentState(intent.key()) != IntentState.WITHDRAWN) {
                intentService.withdraw(intent);
            }
            intentService.purge(intent);
        }
    }

    private void wipeOutHosts() {
        this.print("Wiping hosts", new Object[0]);
        HostAdminService hostAdminService = WipeOutCommand.get(HostAdminService.class);
        while (hostAdminService.getHostCount() > 0) {
            try {
                for (Host host : hostAdminService.getHosts()) {
                    hostAdminService.removeHost(host.id());
                }
            }
            catch (Exception e) {
                this.log.warn("Unable to wipe-out hosts", (Throwable)e);
            }
        }
    }

    private void wipeOutDevices() {
        this.print("Wiping devices", new Object[0]);
        DeviceAdminService deviceAdminService = WipeOutCommand.get(DeviceAdminService.class);
        while (deviceAdminService.getDeviceCount() > 0) {
            try {
                for (Device device : deviceAdminService.getDevices()) {
                    deviceAdminService.removeDevice(device.id());
                }
            }
            catch (Exception e) {
                this.log.warn("Unable to wipe-out devices", (Throwable)e);
            }
        }
    }

    private void wipeOutLinks() {
        this.print("Wiping links", new Object[0]);
        LinkAdminService linkAdminService = WipeOutCommand.get(LinkAdminService.class);
        while (linkAdminService.getLinkCount() > 0) {
            try {
                for (Link link : linkAdminService.getLinks()) {
                    linkAdminService.removeLinks(link.src());
                    linkAdminService.removeLinks(link.dst());
                }
            }
            catch (Exception e) {
                this.log.warn("Unable to wipe-out links", (Throwable)e);
            }
        }
    }
}

