/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.HashSet;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.net.ConnectivityIntentCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;

@Command(scope="onos", name="add-single-to-multi-intent", description="Installs connectivity intent between a single ingress device and multiple egress devices")
public class AddSinglePointToMultiPointIntentCommand
extends ConnectivityIntentCommand {
    @Argument(index=0, name="ingressDevice egressDevices", description="ingressDevice/Port egressDevice/Port...egressDevice/Port", required=true, multiValued=true)
    String[] deviceStrings = null;

    @Override
    protected void execute() {
        IntentService service = AddSinglePointToMultiPointIntentCommand.get(IntentService.class);
        if (this.deviceStrings.length < 2) {
            return;
        }
        String ingressDeviceString = this.deviceStrings[0];
        ConnectPoint ingressPoint = ConnectPoint.deviceConnectPoint((String)ingressDeviceString);
        HashSet<ConnectPoint> egressPoints = new HashSet<ConnectPoint>();
        for (int index = 1; index < this.deviceStrings.length; ++index) {
            String egressDeviceString = this.deviceStrings[index];
            ConnectPoint egress = ConnectPoint.deviceConnectPoint((String)egressDeviceString);
            egressPoints.add(egress);
        }
        TrafficSelector selector = this.buildTrafficSelector();
        TrafficTreatment treatment = this.buildTrafficTreatment();
        List<Constraint> constraints = this.buildConstraints();
        SinglePointToMultiPointIntent intent = SinglePointToMultiPointIntent.builder().appId(this.appId()).key(this.key()).selector(selector).treatment(treatment).ingressPoint(ingressPoint).egressPoints(egressPoints).constraints(constraints).priority(this.priority()).build();
        service.submit((Intent)intent);
        this.print("Single point to multipoint intent submitted:\n%s", intent.toString());
    }
}

