/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Map;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.routing.Route;
import org.onosproject.incubator.net.routing.RouteService;
import org.onosproject.incubator.net.routing.RouteTableId;

@Command(scope="onos", name="routes", description="Lists all routes in the route store")
public class RoutesListCommand
extends AbstractShellCommand {
    @Option(name="-s", aliases={"--summary"}, description="Show summary of routes")
    private boolean summary = false;
    private static final String FORMAT_SUMMARY = "Number of routes in table %s: %s";
    private static final String FORMAT_HEADER = "   Network            Next Hop";
    private static final String FORMAT_ROUTE = "   %-18s %-15s";
    private static final String FORMAT_TABLE = "Table: %s";
    private static final String FORMAT_TOTAL = "   Total: %d";

    @Override
    protected void execute() {
        RouteService service = AbstractShellCommand.get(RouteService.class);
        Map allRoutes = service.getAllRoutes();
        if (this.summary) {
            if (this.outputJson()) {
                ObjectMapper mapper = new ObjectMapper();
                ObjectNode result = mapper.createObjectNode();
                result.put("totalRoutes4", ((Collection)allRoutes.get(new RouteTableId("ipv4"))).size());
                result.put("totalRoutes6", ((Collection)allRoutes.get(new RouteTableId("ipv6"))).size());
                this.print("%s", result);
            } else {
                allRoutes.forEach((id, routes) -> this.print(FORMAT_SUMMARY, id, routes.size()));
            }
            return;
        }
        if (this.outputJson()) {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode result = mapper.createObjectNode();
            result.set("routes4", this.json((Collection)allRoutes.get(new RouteTableId("ipv4"))));
            result.set("routes6", this.json((Collection)allRoutes.get(new RouteTableId("ipv6"))));
            this.print("%s", result);
        } else {
            allRoutes.forEach((id, routes) -> {
                this.print(FORMAT_TABLE, id);
                this.print(FORMAT_HEADER, new Object[0]);
                routes.forEach(r -> this.print(FORMAT_ROUTE, r.prefix(), r.nextHop()));
                this.print(FORMAT_TOTAL, routes.size());
                this.print("", new Object[0]);
            });
        }
    }

    private JsonNode json(Collection<Route> routes) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Route route : routes) {
            result.add((JsonNode)this.json(mapper, route));
        }
        return result;
    }

    private ObjectNode json(ObjectMapper mapper, Route route) {
        ObjectNode result = mapper.createObjectNode();
        result.put("prefix", route.prefix().toString());
        result.put("nextHop", route.nextHop().toString());
        return result;
    }
}

