/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net.vnet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.VirtualPort;
import org.onosproject.net.DeviceId;
import org.onosproject.utils.Comparators;

@Command(scope="onos", name="vnet-ports", description="Lists all virtual ports in a virtual network.")
public class VirtualPortListCommand
extends AbstractShellCommand {
    private static final String FMT_VIRTUAL_PORT = "virtual portNumber=%s, physical deviceId=%s, portNumber=%s";
    @Argument(index=0, name="networkId", description="Network ID", required=true, multiValued=false)
    Long networkId = null;
    @Argument(index=1, name="deviceId", description="Virtual Device ID", required=true, multiValued=false)
    String deviceId = null;

    @Override
    protected void execute() {
        this.getSortedVirtualPorts().forEach(this::printVirtualPort);
    }

    private List<VirtualPort> getSortedVirtualPorts() {
        VirtualNetworkService service = VirtualPortListCommand.get(VirtualNetworkService.class);
        ArrayList<VirtualPort> virtualPorts = new ArrayList<VirtualPort>();
        virtualPorts.addAll(service.getVirtualPorts(NetworkId.networkId((long)this.networkId), DeviceId.deviceId((String)this.deviceId)));
        Collections.sort(virtualPorts, Comparators.VIRTUAL_PORT_COMPARATOR);
        return virtualPorts;
    }

    private void printVirtualPort(VirtualPort virtualPort) {
        this.print(FMT_VIRTUAL_PORT, virtualPort.number(), virtualPort.realizedBy().element().id(), virtualPort.realizedBy().number());
    }
}

