/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.MacAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.Device;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;

@Command(scope="onos", name="add-test-flows", description="Installs a number of test flow rules - for testing only")
public class AddTestFlowsCommand
extends AbstractShellCommand {
    private static final int MAX_OUT_PORT = 65279;
    private CountDownLatch latch;
    @Argument(index=0, name="flowPerDevice", description="Number of flows to add per device", required=true, multiValued=false)
    String flows = null;
    @Argument(index=1, name="numOfRuns", description="Number of iterations", required=true, multiValued=false)
    String numOfRuns = null;

    @Override
    protected void execute() {
        FlowRuleService flowService = AddTestFlowsCommand.get(FlowRuleService.class);
        DeviceService deviceService = AddTestFlowsCommand.get(DeviceService.class);
        CoreService coreService = AddTestFlowsCommand.get(CoreService.class);
        ApplicationId appId = coreService.registerApplication("onos.test.flow.installer");
        int flowsPerDevice = Integer.parseInt(this.flows);
        final int num = Integer.parseInt(this.numOfRuns);
        final ArrayList results = Lists.newArrayList();
        Iterable devices = deviceService.getDevices();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(PortNumber.portNumber((long)RandomUtils.nextInt((int)65279))).build();
        FlowRuleOperations.Builder rules = FlowRuleOperations.builder();
        FlowRuleOperations.Builder remove = FlowRuleOperations.builder();
        for (Device d : devices) {
            for (int i = 0; i < flowsPerDevice; ++i) {
                TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder();
                sbuilder.matchEthSrc(MacAddress.valueOf((long)(RandomUtils.nextInt() * i))).matchEthDst(MacAddress.valueOf((long)((Integer.MAX_VALUE - i) * RandomUtils.nextInt())));
                int randomPriority = RandomUtils.nextInt();
                FlowRule addRule = DefaultFlowRule.builder().forDevice(d.id()).withSelector(sbuilder.build()).withTreatment(treatment).withPriority(randomPriority).fromApp(appId).makeTemporary(10).build();
                FlowRule removeRule = DefaultFlowRule.builder().forDevice(d.id()).withSelector(sbuilder.build()).withTreatment(treatment).withPriority(randomPriority).fromApp(appId).makeTemporary(10).build();
                rules.add(addRule);
                remove.remove(removeRule);
            }
        }
        for (int i = 0; i < num; ++i) {
            this.latch = new CountDownLatch(2);
            flowService.apply(rules.build(new FlowRuleOperationsContext(){
                private final Stopwatch timer = Stopwatch.createStarted();

                public void onSuccess(FlowRuleOperations ops) {
                    this.timer.stop();
                    results.add(this.timer.elapsed(TimeUnit.MILLISECONDS));
                    if (results.size() == num) {
                        if (AddTestFlowsCommand.this.outputJson()) {
                            AddTestFlowsCommand.this.print("%s", AddTestFlowsCommand.this.json(new ObjectMapper(), true, results));
                        } else {
                            AddTestFlowsCommand.this.printTime(true, results);
                        }
                    }
                    AddTestFlowsCommand.this.latch.countDown();
                }
            }));
            flowService.apply(remove.build(new FlowRuleOperationsContext(){

                public void onSuccess(FlowRuleOperations ops) {
                    AddTestFlowsCommand.this.latch.countDown();
                }
            }));
            try {
                this.latch.await();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private Object json(ObjectMapper mapper, boolean isSuccess, ArrayList<Long> elapsed) {
        ObjectNode result = mapper.createObjectNode();
        result.put("Success", isSuccess);
        ArrayNode node = result.putArray("elapsed-time");
        for (Long v : elapsed) {
            node.add(v);
        }
        return result;
    }

    private void printTime(boolean isSuccess, ArrayList<Long> elapsed) {
        this.print("Run is %s.", isSuccess ? "success" : "failure");
        for (int i = 0; i < elapsed.size(); ++i) {
            this.print("  Run %s : %s", i, elapsed.get(i));
        }
    }
}

