/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.utils.Comparators;

@Command(scope="onos", name="masters", description="Lists device mastership information")
public class MastersListCommand
extends AbstractShellCommand {
    @Override
    protected void execute() {
        ClusterService service = MastersListCommand.get(ClusterService.class);
        MastershipService mastershipService = MastersListCommand.get(MastershipService.class);
        ArrayList nodes = Lists.newArrayList((Iterable)service.getNodes());
        Collections.sort(nodes, Comparators.NODE_COMPARATOR);
        if (this.outputJson()) {
            this.print("%s", this.json(service, mastershipService, nodes));
        } else {
            for (ControllerNode node : nodes) {
                ArrayList ids = Lists.newArrayList((Iterable)mastershipService.getDevicesOf(node.id()));
                Collections.sort(ids, Comparators.ELEMENT_ID_COMPARATOR);
                this.print("%s: %d devices", node.id(), ids.size());
                for (DeviceId deviceId : ids) {
                    this.print("  %s", deviceId);
                }
            }
        }
    }

    private JsonNode json(ClusterService service, MastershipService mastershipService, List<ControllerNode> nodes) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        ControllerNode self = service.getLocalNode();
        for (ControllerNode node : nodes) {
            ArrayList ids = Lists.newArrayList((Iterable)mastershipService.getDevicesOf(node.id()));
            result.add(mapper.createObjectNode().put("id", node.id().toString()).put("size", ids.size()).set("devices", MastersListCommand.json(mapper, ids)));
        }
        return result;
    }

    public static JsonNode json(ObjectMapper mapper, Iterable<DeviceId> ids) {
        ArrayNode result = mapper.createArrayNode();
        for (DeviceId deviceId : ids) {
            result.add(deviceId.toString());
        }
        return result;
    }
}

