/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.service.MapInfo;
import org.onosproject.store.service.StorageAdminService;

@Command(scope="onos", name="maps", description="Lists information about consistent maps in the system")
public class MapsListCommand
extends AbstractShellCommand {
    private static final String FMT = "name=%s size=%d";

    private void displayMaps(List<MapInfo> mapInfo) {
        for (MapInfo info : mapInfo) {
            this.print(FMT, info.name(), info.size());
        }
    }

    private JsonNode json(List<MapInfo> mapInfo) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode maps = mapper.createArrayNode();
        mapInfo.forEach(info -> {
            ObjectNode map = mapper.createObjectNode();
            map.put("name", info.name()).put("size", info.size());
            maps.add((JsonNode)map);
        });
        return maps;
    }

    @Override
    protected void execute() {
        StorageAdminService storageAdminService = MapsListCommand.get(StorageAdminService.class);
        List mapInfo = storageAdminService.getMapInfo();
        if (this.outputJson()) {
            this.print("%s", this.json(mapInfo));
        } else {
            this.displayMaps(mapInfo);
        }
    }
}

