/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.mcast.MulticastRouteService;

@Command(scope="onos", name="mcast-join", description="Installs a source, multicast group flow")
public class McastJoinCommand
extends AbstractShellCommand {
    @Argument(index=0, name="sAddr", description="IP Address of the multicast source. '*' can be used for any source (*, G) entry", required=true, multiValued=false)
    String sAddr = null;
    @Argument(index=1, name="gAddr", description="IP Address of the multicast group", required=true, multiValued=false)
    String gAddr = null;
    @Argument(index=2, name="ingressPort", description="Ingress port of:XXXXXXXXXX/XX", required=false, multiValued=false)
    String ingressPort = null;
    @Argument(index=3, name="ports", description="Egress ports of:XXXXXXXXXX/XX...", required=false, multiValued=true)
    String[] ports = null;

    @Override
    protected void execute() {
        MulticastRouteService mcastRouteManager = McastJoinCommand.get(MulticastRouteService.class);
        McastRoute mRoute = new McastRoute(IpAddress.valueOf((String)this.sAddr), IpAddress.valueOf((String)this.gAddr), McastRoute.Type.STATIC);
        mcastRouteManager.add(mRoute);
        if (this.ingressPort != null) {
            ConnectPoint ingress = ConnectPoint.deviceConnectPoint((String)this.ingressPort);
            mcastRouteManager.addSource(mRoute, ingress);
        }
        if (this.ports != null) {
            for (String egCP : this.ports) {
                this.log.debug("Egress port provided: " + egCP);
                ConnectPoint egress = ConnectPoint.deviceConnectPoint((String)egCP);
                mcastRouteManager.addSink(mRoute, egress);
            }
        }
        this.print("Added the mcast route: %s", mRoute);
    }
}

