/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.MastersListCommand;
import org.onosproject.cli.net.ClustersListCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.topology.ClusterId;
import org.onosproject.net.topology.TopologyCluster;
import org.onosproject.utils.Comparators;

@Command(scope="onos", name="cluster-devices", description="Lists devices of the specified topology cluster in the current topology")
public class ClusterDevicesCommand
extends ClustersListCommand {
    @Argument(index=0, name="id", description="Cluster ID", required=true, multiValued=false)
    String id = null;

    @Override
    protected void execute() {
        int cid = Integer.parseInt(this.id);
        this.init();
        TopologyCluster cluster = this.service.getCluster(this.topology, ClusterId.clusterId((int)cid));
        if (cluster == null) {
            this.error("No such cluster %s", cid);
        } else {
            ArrayList ids = Lists.newArrayList((Iterable)this.service.getClusterDevices(this.topology, cluster));
            Collections.sort(ids, Comparators.ELEMENT_ID_COMPARATOR);
            if (this.outputJson()) {
                this.print("%s", MastersListCommand.json(new ObjectMapper(), ids));
            } else {
                for (DeviceId deviceId : ids) {
                    this.print("%s", deviceId);
                }
            }
        }
    }
}

