/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.edge.EdgePortService;
import org.onosproject.utils.Comparators;

@Command(scope="onos", name="edge-ports", description="Lists all edge ports.")
public class EdgePortsListCommand
extends AbstractShellCommand {
    private static final String FMT = "%s/%s";
    @Argument(index=0, name="uri", description="Device ID", required=false, multiValued=false)
    String uri = null;

    @Override
    protected void execute() {
        EdgePortService service = EdgePortsListCommand.get(EdgePortService.class);
        if (this.uri == null) {
            this.printEdgePoints(service.getEdgePoints());
        } else {
            this.printEdgePoints(service.getEdgePoints(DeviceId.deviceId((String)this.uri)));
        }
    }

    private void printEdgePoints(Iterable<ConnectPoint> edgePoints) {
        EdgePortsListCommand.sort(edgePoints).forEach(e -> this.print(FMT, e.deviceId(), e.port()));
    }

    private static List<ConnectPoint> sort(Iterable<ConnectPoint> connectPoints) {
        ArrayList edgePoints = Lists.newArrayList(connectPoints);
        Collections.sort(edgePoints, Comparators.CONNECT_POINT_COMPARATOR);
        return edgePoints;
    }
}

