/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.Collections;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.CoreService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultBand;
import org.onosproject.net.meter.DefaultMeterRequest;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterRequest;
import org.onosproject.net.meter.MeterService;

@Command(scope="onos", name="add-meter", description="Adds a meter to a device (currently for testing)")
public class AddMeterCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    String uri = null;
    private final String appId = "org.onosproject.cli.meterCmd";

    @Override
    protected void execute() {
        MeterService service = AddMeterCommand.get(MeterService.class);
        CoreService coreService = AddMeterCommand.get(CoreService.class);
        DeviceId deviceId = DeviceId.deviceId((String)this.uri);
        Band band = DefaultBand.builder().ofType(Band.Type.DROP).withRate(500L).build();
        MeterRequest request = DefaultMeterRequest.builder().forDevice(deviceId).fromApp(coreService.registerApplication("org.onosproject.cli.meterCmd")).withUnit(Meter.Unit.KB_PER_SEC).withBands(Collections.singleton(band)).add();
        service.submit(request);
    }
}

