/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.NoSuchElementException;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.domain.IntentDomain;
import org.onosproject.incubator.net.domain.IntentDomainId;
import org.onosproject.incubator.net.domain.IntentDomainService;
import org.onosproject.incubator.net.domain.IntentPrimitive;
import org.onosproject.incubator.net.domain.TunnelPrimitive;
import org.onosproject.net.ConnectPoint;

@Command(scope="onos", name="add-domain-tunnel", description="Installs intent domain tunnel primitive")
public class AddTunnelCommand
extends AbstractShellCommand {
    @Argument(index=0, name="one", description="Port one", required=true, multiValued=false)
    String oneString = null;
    @Argument(index=1, name="two", description="Port two", required=true, multiValued=false)
    String twoString = null;

    @Override
    protected void execute() {
        IntentDomainId domainId;
        IntentDomainService service = AddTunnelCommand.get(IntentDomainService.class);
        ConnectPoint one = ConnectPoint.deviceConnectPoint((String)this.oneString);
        ConnectPoint two = ConnectPoint.deviceConnectPoint((String)this.twoString);
        TunnelPrimitive tunnel = new TunnelPrimitive(this.appId(), one, two);
        try {
            domainId = ((IntentDomain)service.getDomains().iterator().next()).id();
        }
        catch (NullPointerException | NoSuchElementException e) {
            this.print("No domains found", new Object[0]);
            return;
        }
        service.request(domainId, (IntentPrimitive)tunnel).forEach(r -> service.submit(domainId, r));
        this.print("Intent domain tunnel submitted:\n%s", tunnel);
    }
}

