/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Collections2;
import java.util.Collection;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterService;

@Command(scope="onos", name="meters", description="Shows meters")
public class MetersListCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=false, multiValued=false)
    String uri = null;

    @Override
    protected void execute() {
        MeterService service = MetersListCommand.get(MeterService.class);
        Collection meters = service.getAllMeters();
        if (this.uri != null) {
            DeviceId deviceId = DeviceId.deviceId((String)this.uri);
            Collection devMeters = Collections2.filter((Collection)meters, m -> m.deviceId().equals((Object)deviceId));
            this.printMeters(devMeters);
        } else {
            this.printMeters(meters);
        }
    }

    private void printMeters(Collection<Meter> meters) {
        meters.forEach(m -> this.print(" %s", m));
    }
}

