/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Strings;
import java.math.BigInteger;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.Key;

@Command(scope="onos", name="remove-intent", description="Removes the specified intent")
public class IntentRemoveCommand
extends AbstractShellCommand {
    @Argument(index=0, name="app", description="Application ID", required=false, multiValued=false)
    String applicationIdString = null;
    @Argument(index=1, name="key", description="Intent Key", required=false, multiValued=false)
    String keyString = null;
    @Option(name="-p", aliases={"--purge"}, description="Purge the intent from the store after removal", required=false, multiValued=false)
    private boolean purgeAfterRemove = false;
    @Option(name="-s", aliases={"--sync"}, description="Waits for the removal before returning", required=false, multiValued=false)
    private boolean sync = false;
    private static final EnumSet<IntentState> CAN_PURGE = EnumSet.of(IntentState.WITHDRAWN, IntentState.FAILED);

    @Override
    protected void execute() {
        IntentService intentService = IntentRemoveCommand.get(IntentService.class);
        CoreService coreService = IntentRemoveCommand.get(CoreService.class);
        if (this.purgeAfterRemove || this.sync) {
            this.print("Using \"sync\" to remove/purge intents - this may take a while...", new Object[0]);
            this.print("Check \"summary\" to see remove/purge progress.", new Object[0]);
        }
        ApplicationId appId = this.appId();
        if (!Strings.isNullOrEmpty((String)this.applicationIdString) && (appId = coreService.getAppId(this.applicationIdString)) == null) {
            this.print("Cannot find application Id %s", this.applicationIdString);
            return;
        }
        if (Strings.isNullOrEmpty((String)this.keyString)) {
            for (Intent intent : intentService.getIntents()) {
                if (!intent.appId().equals(appId)) continue;
                this.removeIntent(intentService, intent);
            }
        } else {
            Key key;
            if (this.keyString.startsWith("0x")) {
                this.keyString = this.keyString.replaceFirst("0x", "");
                key = Key.of((long)new BigInteger(this.keyString, 16).longValue(), (ApplicationId)appId);
            } else {
                key = Key.of((String)this.keyString, (ApplicationId)appId);
            }
            Intent intent = intentService.getIntent(key);
            if (intent != null) {
                this.removeIntent(intentService, intent);
            }
        }
    }

    private void removeIntent(IntentService intentService, Intent intent) {
        CountDownLatch purgeLatch;
        CountDownLatch withdrawLatch;
        IntentListener listener = null;
        Key key = intent.key();
        if (this.purgeAfterRemove || this.sync) {
            withdrawLatch = new CountDownLatch(1);
            purgeLatch = this.purgeAfterRemove ? new CountDownLatch(1) : null;
            listener = event -> {
                if (Objects.equals(((Intent)event.subject()).key(), key)) {
                    if (event.type() == IntentEvent.Type.WITHDRAWN || event.type() == IntentEvent.Type.FAILED) {
                        withdrawLatch.countDown();
                    } else if (this.purgeAfterRemove && event.type() == IntentEvent.Type.PURGED) {
                        purgeLatch.countDown();
                    }
                }
            };
            intentService.addListener((EventListener)listener);
        } else {
            purgeLatch = null;
            withdrawLatch = null;
        }
        intentService.withdraw(intent);
        if (this.purgeAfterRemove || this.sync) {
            try {
                withdrawLatch.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.print("Timed out waiting for intent {} withdraw", key);
            }
            if (this.purgeAfterRemove && CAN_PURGE.contains(intentService.getIntentState(key))) {
                intentService.purge(intent);
                if (this.sync) {
                    try {
                        purgeLatch.await(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        this.print("Timed out waiting for intent {} purge", key);
                    }
                }
            }
        }
        if (listener != null) {
            intentService.removeListener((EventListener)listener);
        }
    }
}

