/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net.vnet;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkAdminService;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.VirtualPort;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;

@Command(scope="onos", name="vnet-bind-port", description="Binds an existing virtual port with a physical port.")
public class VirtualPortBindCommand
extends AbstractShellCommand {
    @Argument(index=0, name="networkId", description="Network ID", required=true, multiValued=false)
    Long networkId = null;
    @Argument(index=1, name="deviceId", description="Virtual Device ID", required=true, multiValued=false)
    String deviceId = null;
    @Argument(index=2, name="portNum", description="Virtual device port number", required=true, multiValued=false)
    Integer portNum = null;
    @Argument(index=3, name="physDeviceId", description="Physical Device ID", required=true, multiValued=false)
    String physDeviceId = null;
    @Argument(index=4, name="physPortNum", description="Physical device port number", required=true, multiValued=false)
    Integer physPortNum = null;

    @Override
    protected void execute() {
        VirtualNetworkAdminService service = VirtualPortBindCommand.get(VirtualNetworkAdminService.class);
        DeviceService deviceService = VirtualPortBindCommand.get(DeviceService.class);
        VirtualPort vPort = this.getVirtualPort(PortNumber.portNumber((long)this.portNum.intValue()));
        Preconditions.checkNotNull((Object)vPort, (Object)"The virtual Port does not exist");
        ConnectPoint realizedBy = new ConnectPoint((ElementId)DeviceId.deviceId((String)this.physDeviceId), PortNumber.portNumber((long)this.physPortNum.intValue()));
        service.bindVirtualPort(NetworkId.networkId((long)this.networkId), DeviceId.deviceId((String)this.deviceId), PortNumber.portNumber((long)this.portNum.intValue()), realizedBy);
        this.print("Virtual port is successfully bound.", new Object[0]);
    }

    private VirtualPort getVirtualPort(PortNumber aPortNumber) {
        VirtualNetworkService service = VirtualPortBindCommand.get(VirtualNetworkService.class);
        Set ports = service.getVirtualPorts(NetworkId.networkId((long)this.networkId), DeviceId.deviceId((String)this.deviceId));
        return ports.stream().filter(p -> p.number().equals((Object)aPortNumber)).findFirst().get();
    }
}

