/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.net.ConnectivityIntentCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.intent.constraint.ProtectedConstraint;
import org.onosproject.net.intent.constraint.ProtectionConstraint;

@Command(scope="onos", name="add-point-intent", description="Installs point-to-point connectivity intent")
public class AddPointToPointIntentCommand
extends ConnectivityIntentCommand {
    @Argument(index=0, name="ingressDevice", description="Ingress Device/Port Description", required=true, multiValued=false)
    String ingressDeviceString = null;
    @Argument(index=1, name="egressDevice", description="Egress Device/Port Description", required=true, multiValued=false)
    String egressDeviceString = null;
    @Deprecated
    @Option(name="-r", aliases={"--protect"}, description="(deprecated) Utilize path protection", required=false, multiValued=false)
    private boolean backup = false;
    @Option(name="--useProtected", description="use protected links only")
    private boolean useProtected = false;

    @Override
    protected void execute() {
        IntentService service = AddPointToPointIntentCommand.get(IntentService.class);
        ConnectPoint ingress = ConnectPoint.deviceConnectPoint((String)this.ingressDeviceString);
        ConnectPoint egress = ConnectPoint.deviceConnectPoint((String)this.egressDeviceString);
        TrafficSelector selector = this.buildTrafficSelector();
        TrafficTreatment treatment = this.buildTrafficTreatment();
        List<Constraint> constraints = this.buildConstraints();
        if (this.backup) {
            constraints.add((Constraint)ProtectionConstraint.protection());
        }
        if (this.useProtected) {
            constraints.add((Constraint)ProtectedConstraint.useProtectedLink());
        }
        PointToPointIntent intent = PointToPointIntent.builder().appId(this.appId()).key(this.key()).selector(selector).treatment(treatment).ingressPoint(ingress).egressPoint(egress).constraints(constraints).priority(this.priority()).build();
        service.submit((Intent)intent);
        this.print("Point to point intent submitted:\n%s", intent.toString());
    }
}

