/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.List;
import java.util.Map;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.StoredFlowEntry;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.statistic.FlowEntryWithLoad;
import org.onosproject.net.statistic.FlowStatisticService;
import org.onosproject.net.statistic.SummaryFlowEntryWithLoad;

@Command(scope="onos", name="get-flow-stats", description="Fetches flow stats for a connection point with given flow type and instruction type")
public class GetFlowStatisticsCommand
extends AbstractShellCommand {
    @Argument(index=0, name="devicePort", description="Device[/Port] connectPoint Description", required=true, multiValued=false)
    String devicePort = null;
    @Option(name="-s", aliases={"--summary"}, description="Show flow stats summary", required=false, multiValued=false)
    boolean showSummary = true;
    @Option(name="-a", aliases={"--all"}, description="Show flow stats all", required=false, multiValued=false)
    boolean showAll = false;
    @Option(name="-t", aliases={"--topn"}, description="Show flow stats topn entry", required=false, multiValued=false)
    String showTopn = null;
    @Option(name="-f", aliases={"--flowType"}, description="Flow live type, It includes IMMEDIATE, SHORT, MID, LONG, UNKNOWN, and is valid with -a or -t option only", required=false, multiValued=false)
    String flowLiveType = null;
    @Option(name="-i", aliases={"--instructionType"}, description="Flow instruction type, It includes DROP, OUTPUT, GROUP, L0MODIFICATION, L2MODIFICATION, TABLE, L3MODIFICATION, METADATA, and is valid with -a or -t option only", required=false, multiValued=false)
    String instructionType = null;

    @Override
    protected void execute() {
        Instruction.Type inInstructionType;
        FlowEntry.FlowLiveType inLiveType;
        Port port;
        DeviceService deviceService = GetFlowStatisticsCommand.get(DeviceService.class);
        FlowStatisticService flowStatsService = GetFlowStatisticsCommand.get(FlowStatisticService.class);
        String deviceUri = this.getDeviceId(this.devicePort);
        String portUri = this.getPortNumber(this.devicePort);
        DeviceId ingressDeviceId = DeviceId.deviceId((String)deviceUri);
        PortNumber ingressPortNumber = portUri.length() == 0 ? null : PortNumber.portNumber((String)portUri);
        Device device = deviceService.getDevice(ingressDeviceId);
        if (device == null) {
            this.error("No such device %s", ingressDeviceId.uri());
            return;
        }
        if (ingressPortNumber != null && (port = deviceService.getPort(ingressDeviceId, ingressPortNumber)) == null) {
            this.error("No such port %s on device %s", portUri, ingressDeviceId.uri());
            return;
        }
        if (this.flowLiveType != null) {
            this.flowLiveType = this.flowLiveType.toUpperCase();
        }
        if (this.instructionType != null) {
            this.instructionType = this.instructionType.toUpperCase();
        }
        if (this.flowLiveType == null) {
            inLiveType = null;
        } else {
            inLiveType = this.getFlowLiveType(this.flowLiveType);
            if (inLiveType == null) {
                this.error("Invalid flow live type [%s] error", this.flowLiveType);
                return;
            }
        }
        if (this.instructionType == null) {
            inInstructionType = null;
        } else {
            inInstructionType = this.getInstructionType(this.instructionType);
            if (inInstructionType == null) {
                this.error("Invalid instruction type [%s] error", this.instructionType);
                return;
            }
        }
        if (this.showTopn != null) {
            int topn = Integer.parseInt(this.showTopn);
            if (topn <= 0) {
                topn = 100;
            } else if (topn > 1000) {
                topn = 1000;
            }
            this.print("deviceId=%s, show TOPN=%s flows, liveType=%s, instruction type=%s", deviceUri, Integer.toString(topn), this.flowLiveType == null ? "ALL" : this.flowLiveType, this.instructionType == null ? "ALL" : this.instructionType);
            if (ingressPortNumber == null) {
                Map typedFlowLoadMap = flowStatsService.loadTopnByType(device, inLiveType, inInstructionType, topn);
                for (ConnectPoint cp : typedFlowLoadMap.keySet()) {
                    this.printPortFlowsLoad(cp, (List)typedFlowLoadMap.get(cp));
                }
            } else {
                List typedFlowLoad = flowStatsService.loadTopnByType(device, ingressPortNumber, inLiveType, inInstructionType, topn);
                ConnectPoint cp = new ConnectPoint((ElementId)ingressDeviceId, ingressPortNumber);
                this.printPortFlowsLoad(cp, typedFlowLoad);
            }
        } else if (this.showAll) {
            this.print("deviceId=%s, show ALL flows, liveType=%s, instruction type=%s", deviceUri, this.flowLiveType == null ? "ALL" : this.flowLiveType, this.instructionType == null ? "ALL" : this.instructionType);
            if (ingressPortNumber == null) {
                Map typedFlowLoadMap = flowStatsService.loadAllByType(device, inLiveType, inInstructionType);
                for (ConnectPoint cp : typedFlowLoadMap.keySet()) {
                    this.printPortFlowsLoad(cp, (List)typedFlowLoadMap.get(cp));
                }
            } else {
                List typedFlowLoad = flowStatsService.loadAllByType(device, ingressPortNumber, inLiveType, inInstructionType);
                ConnectPoint cp = new ConnectPoint((ElementId)ingressDeviceId, ingressPortNumber);
                this.printPortFlowsLoad(cp, typedFlowLoad);
            }
        } else {
            this.print("deviceId=%s, show SUMMARY flows", deviceUri);
            if (ingressPortNumber == null) {
                Map summaryFlowLoadMap = flowStatsService.loadSummary(device);
                for (ConnectPoint cp : summaryFlowLoadMap.keySet()) {
                    this.printPortSummaryLoad(cp, (SummaryFlowEntryWithLoad)summaryFlowLoadMap.get(cp));
                }
            } else {
                SummaryFlowEntryWithLoad summaryFlowLoad = flowStatsService.loadSummary(device, ingressPortNumber);
                ConnectPoint cp = new ConnectPoint((ElementId)ingressDeviceId, ingressPortNumber);
                this.printPortSummaryLoad(cp, summaryFlowLoad);
            }
        }
    }

    private String getPortNumber(String deviceString) {
        if (deviceString == null) {
            return "";
        }
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(slash + 1, deviceString.length());
    }

    private String getDeviceId(String deviceString) {
        if (deviceString == null) {
            return "";
        }
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return deviceString;
        }
        return deviceString.substring(0, slash);
    }

    private FlowEntry.FlowLiveType getFlowLiveType(String liveType) {
        String liveTypeUC = liveType.toUpperCase();
        if (liveTypeUC.equals("IMMEDIATE")) {
            return FlowEntry.FlowLiveType.IMMEDIATE;
        }
        if (liveTypeUC.equals("SHORT")) {
            return FlowEntry.FlowLiveType.SHORT;
        }
        if (liveTypeUC.equals("MID")) {
            return FlowEntry.FlowLiveType.MID;
        }
        if (liveTypeUC.equals("LONG")) {
            return FlowEntry.FlowLiveType.LONG;
        }
        if (liveTypeUC.equals("UNKNOWN")) {
            return FlowEntry.FlowLiveType.UNKNOWN;
        }
        return null;
    }

    private Instruction.Type getInstructionType(String instType) {
        String instTypeUC = instType.toUpperCase();
        if (instTypeUC.equals("OUTPUT")) {
            return Instruction.Type.OUTPUT;
        }
        if (instTypeUC.equals("GROUP")) {
            return Instruction.Type.GROUP;
        }
        if (instTypeUC.equals("L0MODIFICATION")) {
            return Instruction.Type.L0MODIFICATION;
        }
        if (instTypeUC.equals("L2MODIFICATION")) {
            return Instruction.Type.L2MODIFICATION;
        }
        if (instTypeUC.equals("TABLE")) {
            return Instruction.Type.TABLE;
        }
        if (instTypeUC.equals("L3MODIFICATION")) {
            return Instruction.Type.L3MODIFICATION;
        }
        if (instTypeUC.equals("METADATA")) {
            return Instruction.Type.METADATA;
        }
        return null;
    }

    private void printPortFlowsLoad(ConnectPoint cp, List<FlowEntryWithLoad> typedFlowLoad) {
        this.print("  deviceId/Port=%s/%s, %s flows", cp.elementId(), cp.port(), typedFlowLoad.size());
        for (FlowEntryWithLoad fel : typedFlowLoad) {
            StoredFlowEntry sfe = fel.storedFlowEntry();
            this.print("    flowId=%s, state=%s, liveType=%s, life=%s -> %s", Long.toHexString(sfe.id().value()), sfe.state(), sfe.liveType(), sfe.life(), fel.load().isValid() ? fel.load() : "Load{rate=0, NOT VALID}");
        }
    }

    private void printPortSummaryLoad(ConnectPoint cp, SummaryFlowEntryWithLoad summaryFlowLoad) {
        this.print("  deviceId/Port=%s/%s, Total=%s, Immediate=%s, Short=%s, Mid=%s, Long=%s, Unknown=%s", cp.elementId(), cp.port(), summaryFlowLoad.totalLoad().isValid() ? summaryFlowLoad.totalLoad() : "Load{rate=0, NOT VALID}", summaryFlowLoad.immediateLoad().isValid() ? summaryFlowLoad.immediateLoad() : "Load{rate=0, NOT VALID}", summaryFlowLoad.shortLoad().isValid() ? summaryFlowLoad.shortLoad() : "Load{rate=0, NOT VALID}", summaryFlowLoad.midLoad().isValid() ? summaryFlowLoad.midLoad() : "Load{rate=0, NOT VALID}", summaryFlowLoad.longLoad().isValid() ? summaryFlowLoad.longLoad() : "Load{rate=0, NOT VALID}", summaryFlowLoad.unknownLoad().isValid() ? summaryFlowLoad.unknownLoad() : "Load{rate=0, NOT VALID}");
    }
}

