/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;
import org.onosproject.net.region.RegionService;
import org.onosproject.ui.UiTopoLayoutService;
import org.onosproject.ui.model.topo.UiTopoLayout;
import org.onosproject.ui.model.topo.UiTopoLayoutId;

@Command(scope="onos", name="layout-add", description="Creates a new UI layout")
public class LayoutAddCommand
extends AbstractShellCommand {
    private static final String FMT = "id=%s, name=%s, type=%s";
    private static final String FMT_MASTER = "  master=%s";
    @Argument(index=0, name="id", description="Layout ID", required=true, multiValued=false)
    String id = null;
    @Argument(index=1, name="id", description="Region ID (optional)", required=false, multiValued=false)
    String regionId = null;
    @Argument(index=2, name="id", description="Parent layout ID (optional)", required=false, multiValued=false)
    String parentId = null;
    private RegionService regionService;

    @Override
    protected void execute() {
        UiTopoLayoutService service = LayoutAddCommand.get(UiTopoLayoutService.class);
        RegionService regionService = LayoutAddCommand.get(RegionService.class);
        Region region = this.regionId == null ? null : regionService.getRegion(RegionId.regionId((String)this.regionId));
        UiTopoLayoutId pid = this.parentId == null ? UiTopoLayoutId.DEFAULT_ID : UiTopoLayoutId.layoutId((String)this.parentId);
        UiTopoLayout layout = new UiTopoLayout(UiTopoLayoutId.layoutId((String)this.id)).region(region).parent(pid);
        service.addLayout(layout);
    }
}

