/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net.vnet;

import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.net.ConnectivityIntentCommand;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkIntent;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;

@Command(scope="onos", name="add-vnet-intent", description="Installs virtual network connectivity intent")
public class VirtualNetworkIntentCreateCommand
extends ConnectivityIntentCommand {
    @Argument(index=0, name="networkId", description="Network ID", required=true, multiValued=false)
    Long networkId = null;
    @Argument(index=1, name="ingressDevice", description="Ingress Device/Port Description", required=true, multiValued=false)
    String ingressDeviceString = null;
    @Argument(index=2, name="egressDevice", description="Egress Device/Port Description", required=true, multiValued=false)
    String egressDeviceString = null;

    @Override
    protected void execute() {
        VirtualNetworkService service = VirtualNetworkIntentCreateCommand.get(VirtualNetworkService.class);
        IntentService virtualNetworkIntentService = (IntentService)service.get(NetworkId.networkId((long)this.networkId), IntentService.class);
        ConnectPoint ingress = ConnectPoint.deviceConnectPoint((String)this.ingressDeviceString);
        ConnectPoint egress = ConnectPoint.deviceConnectPoint((String)this.egressDeviceString);
        TrafficSelector selector = this.buildTrafficSelector();
        TrafficTreatment treatment = this.buildTrafficTreatment();
        List<Constraint> constraints = this.buildConstraints();
        VirtualNetworkIntent intent = VirtualNetworkIntent.builder().networkId(NetworkId.networkId((long)this.networkId)).appId(this.appId()).key(this.key()).selector(selector).treatment(treatment).ingressPoint(ingress).egressPoint(egress).constraints(constraints).priority(this.priority()).build();
        virtualNetworkIntentService.submit((Intent)intent);
        this.print("Virtual intent submitted:\n%s", intent.toString());
    }
}

