/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.EnumSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.net.ClustersListCommand;
import org.onosproject.net.Device;
import org.onosproject.net.Host;
import org.onosproject.net.Link;
import org.onosproject.net.device.DeviceAdminService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.group.GroupService;
import org.onosproject.net.host.HostAdminService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.link.LinkAdminService;
import org.onosproject.net.region.RegionAdminService;
import org.onosproject.ui.UiTopoLayoutService;

@Command(scope="onos", name="wipe-out", description="Wipes-out the entire network information base, i.e. devices, links, hosts")
public class WipeOutCommand
extends ClustersListCommand {
    private static final String PLEASE = "please";
    private static final EnumSet<IntentState> CAN_PURGE = EnumSet.of(IntentState.WITHDRAWN, IntentState.FAILED);
    @Argument(index=0, name="please", description="Confirmation phrase", required=false, multiValued=false)
    String please = null;

    @Override
    protected void execute() {
        if (this.please == null || !this.please.equals(PLEASE)) {
            this.print("I'm afraid I can't do that!\nSay: %s", PLEASE);
            return;
        }
        this.wipeOutIntents();
        this.wipeOutHosts();
        this.wipeOutFlows();
        this.wipeOutGroups();
        this.wipeOutDevices();
        this.wipeOutLinks();
        this.wipeOutLayouts();
        this.wipeOutRegions();
    }

    private void wipeOutIntents() {
        this.print("Wiping intents", new Object[0]);
        IntentService intentService = WipeOutCommand.get(IntentService.class);
        CountDownLatch withdrawLatch = new CountDownLatch(1);
        for (Intent intent : intentService.getIntents()) {
            if (intentService.getIntentState(intent.key()) != IntentState.WITHDRAWN) {
                intentService.withdraw(intent);
                try {
                    withdrawLatch.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    this.print("Timed out waiting for intent {} withdraw", new Object[0]);
                }
            }
            if (!CAN_PURGE.contains(intentService.getIntentState(intent.key()))) continue;
            intentService.purge(intent);
        }
    }

    private void wipeOutFlows() {
        this.print("Wiping Flows", new Object[0]);
        FlowRuleService flowRuleService = WipeOutCommand.get(FlowRuleService.class);
        DeviceAdminService deviceAdminService = WipeOutCommand.get(DeviceAdminService.class);
        for (Device device : deviceAdminService.getDevices()) {
            flowRuleService.purgeFlowRules(device.id());
        }
    }

    private void wipeOutGroups() {
        this.print("Wiping groups", new Object[0]);
        GroupService groupService = WipeOutCommand.get(GroupService.class);
        DeviceAdminService deviceAdminService = WipeOutCommand.get(DeviceAdminService.class);
        for (Device device : deviceAdminService.getDevices()) {
            groupService.purgeGroupEntries(device.id());
        }
    }

    private void wipeOutHosts() {
        this.print("Wiping hosts", new Object[0]);
        HostAdminService hostAdminService = WipeOutCommand.get(HostAdminService.class);
        while (hostAdminService.getHostCount() > 0) {
            try {
                for (Host host : hostAdminService.getHosts()) {
                    hostAdminService.removeHost(host.id());
                }
            }
            catch (Exception e) {
                this.log.info("Unable to wipe-out hosts", (Throwable)e);
            }
        }
    }

    private void wipeOutDevices() {
        this.print("Wiping devices", new Object[0]);
        DeviceAdminService deviceAdminService = WipeOutCommand.get(DeviceAdminService.class);
        while (deviceAdminService.getDeviceCount() > 0) {
            try {
                for (Device device : deviceAdminService.getDevices()) {
                    deviceAdminService.removeDevice(device.id());
                }
            }
            catch (Exception e) {
                this.log.info("Unable to wipe-out devices", (Throwable)e);
            }
        }
    }

    private void wipeOutLinks() {
        this.print("Wiping links", new Object[0]);
        LinkAdminService linkAdminService = WipeOutCommand.get(LinkAdminService.class);
        while (linkAdminService.getLinkCount() > 0) {
            try {
                for (Link link : linkAdminService.getLinks()) {
                    linkAdminService.removeLinks(link.src());
                    linkAdminService.removeLinks(link.dst());
                }
            }
            catch (Exception e) {
                this.log.info("Unable to wipe-out links", (Throwable)e);
            }
        }
    }

    private void wipeOutLayouts() {
        this.print("Wiping UI layouts", new Object[0]);
        UiTopoLayoutService service = WipeOutCommand.get(UiTopoLayoutService.class);
        service.getLayouts().forEach(l -> {
            if (!l.id().isDefault()) {
                service.removeLayout(l);
            }
        });
    }

    private void wipeOutRegions() {
        this.print("Wiping regions", new Object[0]);
        RegionAdminService service = WipeOutCommand.get(RegionAdminService.class);
        service.getRegions().forEach(r -> service.removeRegion(r.id()));
    }
}

