/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.util.StringFilter;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.intent.OpticalCircuitIntent;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.intent.OpticalOduIntent;
import org.onosproject.net.intent.PathIntent;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;

@Command(scope="onos", name="intents", description="Lists the inventory of intents and their states")
public class IntentsListCommand
extends AbstractShellCommand {
    private static final String BOLD = "\u001b[1m";
    private static final String RESET = "\u001b[0m";
    private static final String APP_ID = "\u001b[1mApplication Id:\u001b[0m %s";
    private static final String COMMON_SELECTOR = "\u001b[1mCommon ingress selector:\u001b[0m %s";
    private static final String CP = "\u001b[1mConnect Point:\u001b[0m %s";
    private static final String CONSTRAINTS = "\u001b[1mConstraints:\u001b[0m %s";
    private static final String DST = "\u001b[1mDestination \u001b[0m";
    private static final String EGRESS = "\u001b[1mEgress ";
    private static final String FILTERED_CPS = "connect points and individual selectors\u001b[0m";
    private static final String HOST = "host:\u001b[0m %s";
    private static final String ID = "\u001b[1mId:\u001b[0m %s";
    private static final String INHERITED = "Inherited";
    private static final String INGRESS = "\u001b[1mIngress ";
    private static final String INDENTATION = " -> ";
    private static final String INSTALLABLE = "\u001b[1mInstallable:\u001b[0m %s";
    private static final String KEY = "\u001b[1mKey:\u001b[0m %s";
    private static final String RESOURCES = "\u001b[1mResources:\u001b[0m %s";
    private static final String SELECTOR = "\u001b[1mSelector:\u001b[0m %s";
    private static final String SEPARATOR = StringUtils.repeat((String)"-", (int)172);
    private static final String SPACE = "   ";
    private static final String SRC = "\u001b[1mSource ";
    private static final String STATE = "\u001b[1mState:\u001b[0m %s";
    private static final String TREATMENT = "\u001b[1mTreatment:\u001b[0m %s";
    private static final String TYPE = "\u001b[1mIntent type:\u001b[0m %s";
    private static final String SUMMARY_TITLES = "\u001b[1m" + String.format("\n%1s%21s%14s%14s%14s%14s%14s%14s%14s%14s%14s%14s", "Intent type", "Total", "Installed", "Withdrawn", "Failed", "InstallReq", "Compiling", "Installing", "Recompiling", "WithdrawReq", "Withdrawing", "UnknownState") + "\u001b[0m";
    @Option(name="-i", aliases={"--installable"}, description="Output Installable Intents", required=false, multiValued=false)
    private boolean showInstallable = false;
    @Option(name="-s", aliases={"--summary"}, description="Intents summary", required=false, multiValued=false)
    private boolean intentsSummary = false;
    @Option(name="-p", aliases={"--pending"}, description="Show information about pending intents", required=false, multiValued=false)
    private boolean pending = false;
    @Option(name="-f", aliases={"--filter"}, description="Filter intents by specific keyword", required=false, multiValued=true)
    private List<String> filter = new ArrayList<String>();
    private StringFilter contentFilter;

    @Override
    protected void execute() {
        IntentService service = IntentsListCommand.get(IntentService.class);
        this.contentFilter = new StringFilter(this.filter, StringFilter.Strategy.AND);
        if (this.intentsSummary) {
            IntentSummaries intentSummaries = new IntentSummaries();
            intentSummaries.collectIntentSummary(service, service.getIntents());
            if (this.outputJson()) {
                this.print("%s", intentSummaries.json());
            } else {
                this.print(intentSummaries.summary(), new Object[0]);
            }
            return;
        }
        if (this.pending) {
            if (this.outputJson()) {
                this.print("%s", this.json(service.getPending()));
            } else {
                StreamSupport.stream(service.getPending().spliterator(), false).filter(intent -> this.contentFilter.filter(intent)).forEach(intent -> this.print(this.fullFormat((Intent)intent), new Object[0]));
            }
            return;
        }
        if (this.outputJson()) {
            this.print("%s", this.json(service.getIntents()));
        } else {
            this.printIntents(service);
        }
    }

    private String detailsFormat(IntentService service, Intent intent) {
        HostToHostIntent pi;
        ConnectivityIntent ci;
        StringBuilder builder = new StringBuilder();
        if (!intent.resources().isEmpty()) {
            builder.append("\n" + String.format(RESOURCES, intent.resources()));
        }
        if (intent instanceof ConnectivityIntent) {
            ci = (ConnectivityIntent)intent;
            if (!ci.selector().criteria().isEmpty()) {
                builder.append("\n" + String.format(COMMON_SELECTOR, this.formatSelector(ci.selector())));
            }
            if (!ci.treatment().allInstructions().isEmpty()) {
                builder.append("\n" + String.format(TREATMENT, ci.treatment().allInstructions()));
            }
            if (ci.constraints() != null && !ci.constraints().isEmpty()) {
                builder.append("\n" + String.format(CONSTRAINTS, ci.constraints()));
            }
        }
        if (intent instanceof HostToHostIntent) {
            pi = (HostToHostIntent)intent;
            builder.append("\n" + String.format("\u001b[1mSource host:\u001b[0m %s", pi.one()));
            builder.append("\n" + String.format("\u001b[1mDestination \u001b[0mhost:\u001b[0m %s", pi.two()));
        } else if (intent instanceof PointToPointIntent) {
            pi = (PointToPointIntent)intent;
            builder.append("\n" + this.formatFilteredCps(Sets.newHashSet((Object[])new FilteredConnectPoint[]{pi.filteredIngressPoint()}), INGRESS));
            builder.append("\n" + this.formatFilteredCps(Sets.newHashSet((Object[])new FilteredConnectPoint[]{pi.filteredEgressPoint()}), EGRESS));
        } else if (intent instanceof MultiPointToSinglePointIntent) {
            pi = (MultiPointToSinglePointIntent)intent;
            builder.append("\n" + this.formatFilteredCps(pi.filteredIngressPoints(), INGRESS));
            builder.append("\n" + this.formatFilteredCps(Sets.newHashSet((Object[])new FilteredConnectPoint[]{pi.filteredEgressPoint()}), EGRESS));
        } else if (intent instanceof SinglePointToMultiPointIntent) {
            pi = (SinglePointToMultiPointIntent)intent;
            builder.append("\n" + this.formatFilteredCps(Sets.newHashSet((Object[])new FilteredConnectPoint[]{pi.filteredIngressPoint()}), INGRESS));
            builder.append("\n" + this.formatFilteredCps(pi.filteredEgressPoints(), EGRESS));
        } else if (intent instanceof PathIntent) {
            pi = (PathIntent)intent;
            builder.append(String.format("path=%s, cost=%f", pi.path().links(), pi.path().cost()));
        } else if (intent instanceof LinkCollectionIntent) {
            LinkCollectionIntent li = (LinkCollectionIntent)intent;
            builder.append("\n" + String.format("links=%s", li.links()));
            builder.append("\n" + String.format(CP, li.egressPoints()));
        } else if (intent instanceof OpticalCircuitIntent) {
            ci = (OpticalCircuitIntent)intent;
            builder.append("\n" + String.format("src=%s, dst=%s", ci.getSrc(), ci.getDst()));
        } else if (intent instanceof OpticalConnectivityIntent) {
            ci = (OpticalConnectivityIntent)intent;
            builder.append("\n" + String.format("src=%s, dst=%s", ci.getSrc(), ci.getDst()));
        } else if (intent instanceof OpticalOduIntent) {
            ci = (OpticalOduIntent)intent;
            builder.append("\n" + String.format("src=%s, dst=%s", ci.getSrc(), ci.getDst()));
        }
        List installable = service.getInstallableIntents(intent.key());
        installable.stream().filter(i -> this.contentFilter.filter(i));
        if (this.showInstallable && installable != null && !installable.isEmpty()) {
            builder.append("\n" + String.format(INSTALLABLE, installable));
        }
        return builder.toString();
    }

    private String formatFilteredCps(Set<FilteredConnectPoint> fCps, String prefix) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        builder.append(FILTERED_CPS);
        fCps.forEach(fCp -> builder.append("\n" + String.format(this.formatFilteredCp((FilteredConnectPoint)fCp), new Object[0])));
        return builder.toString();
    }

    private String formatFilteredCp(FilteredConnectPoint fCp) {
        ConnectPoint connectPoint = fCp.connectPoint();
        TrafficSelector selector = fCp.trafficSelector();
        StringBuilder builder = new StringBuilder();
        builder.append(INDENTATION + String.format(CP, connectPoint));
        builder.append(SPACE + String.format(SELECTOR, this.formatSelector(selector)));
        return builder.toString();
    }

    private String formatSelector(TrafficSelector ts) {
        StringBuilder builder = new StringBuilder();
        ArrayList criteria = Lists.newArrayList((Iterable)ts.criteria());
        if (criteria == null || criteria.isEmpty()) {
            builder.append(INHERITED);
            return builder.toString();
        }
        criteria.forEach(c -> {
            builder.append(c.toString());
            if (criteria.indexOf(c) < criteria.size() - 1) {
                builder.append(", ");
            }
        });
        return builder.toString();
    }

    private String fullFormat(Intent intent) {
        return this.fullFormat(intent, null);
    }

    private String fullFormat(Intent intent, String state) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format(ID, intent.id()));
        if (state != null) {
            builder.append("\n" + String.format(STATE, state));
        }
        builder.append("\n" + String.format(KEY, intent.key()));
        builder.append("\n" + String.format(TYPE, intent.getClass().getSimpleName()));
        builder.append("\n" + String.format(APP_ID, intent.appId().name()));
        return builder.toString();
    }

    private void printIntents(IntentService service) {
        for (Intent intent : service.getIntents()) {
            IntentState state = service.getIntentState(intent.key());
            String intentFormat = this.fullFormat(intent, state.toString());
            String detailsIntentFormat = this.detailsFormat(service, intent);
            if (state == null || !this.contentFilter.filter((Object)(intentFormat + detailsIntentFormat))) continue;
            StringBuilder builder = new StringBuilder();
            builder.append(intentFormat).append(detailsIntentFormat).append("\n");
            this.print(builder.toString(), new Object[0]);
        }
    }

    private JsonNode json(Iterable<Intent> intents) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        StreamSupport.stream(intents.spliterator(), false).filter(intent -> this.contentFilter.filter((Object)this.jsonForEntity(intent, Intent.class).toString())).forEach(intent -> result.add((JsonNode)this.jsonForEntity(intent, Intent.class)));
        return result;
    }

    private class IntentSummaries {
        private IntentSummary summaryAll;
        private IntentSummary summaryConnectivity;
        private IntentSummary summaryHostToHost;
        private IntentSummary summaryPointToPoint;
        private IntentSummary summaryMultiPointToSinglePoint;
        private IntentSummary summarySinglePointToMultiPoint;
        private IntentSummary summaryPath;
        private IntentSummary summaryLinkCollection;
        private IntentSummary summaryOpticalCircuit;
        private IntentSummary summaryOpticalConnectivity;
        private IntentSummary summaryOpticalOdu;
        private IntentSummary summaryUnknownType;

        private IntentSummaries() {
        }

        private void init() {
            this.summaryAll = new IntentSummary("All");
            this.summaryConnectivity = new IntentSummary("Connectivity");
            this.summaryHostToHost = new IntentSummary("HostToHost");
            this.summaryPointToPoint = new IntentSummary("PointToPoint");
            this.summaryMultiPointToSinglePoint = new IntentSummary("MultiPointToSinglePoint");
            this.summarySinglePointToMultiPoint = new IntentSummary("SinglePointToMultiPoint");
            this.summaryPath = new IntentSummary("Path");
            this.summaryLinkCollection = new IntentSummary("LinkCollection");
            this.summaryOpticalCircuit = new IntentSummary("OpticalCircuit");
            this.summaryOpticalConnectivity = new IntentSummary("OpticalConnectivity");
            this.summaryOpticalOdu = new IntentSummary("OpticalOdu");
            this.summaryUnknownType = new IntentSummary("UnknownType");
        }

        private void collectIntentSummary(IntentService service, Iterable<Intent> intents) {
            this.init();
            for (Intent intent : intents) {
                IntentState intentState = service.getIntentState(intent.key());
                if (intentState == null) continue;
                if (!IntentsListCommand.this.contentFilter.filter((Object)intent)) break;
                this.summaryAll.update(intentState);
                if (intent instanceof ConnectivityIntent) {
                    this.summaryConnectivity.update(intentState);
                }
                if (intent instanceof HostToHostIntent) {
                    this.summaryHostToHost.update(intentState);
                    continue;
                }
                if (intent instanceof PointToPointIntent) {
                    this.summaryPointToPoint.update(intentState);
                    continue;
                }
                if (intent instanceof MultiPointToSinglePointIntent) {
                    this.summaryMultiPointToSinglePoint.update(intentState);
                    continue;
                }
                if (intent instanceof SinglePointToMultiPointIntent) {
                    this.summarySinglePointToMultiPoint.update(intentState);
                    continue;
                }
                if (intent instanceof PathIntent) {
                    this.summaryPath.update(intentState);
                    continue;
                }
                if (intent instanceof LinkCollectionIntent) {
                    this.summaryLinkCollection.update(intentState);
                    continue;
                }
                if (intent instanceof OpticalCircuitIntent) {
                    this.summaryOpticalCircuit.update(intentState);
                    continue;
                }
                if (intent instanceof OpticalConnectivityIntent) {
                    this.summaryOpticalConnectivity.update(intentState);
                    continue;
                }
                if (intent instanceof OpticalOduIntent) {
                    this.summaryOpticalOdu.update(intentState);
                    continue;
                }
                this.summaryUnknownType.update(intentState);
            }
        }

        ObjectNode json() {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode result = mapper.createObjectNode();
            result.set("connectivity", this.summaryConnectivity.json(mapper));
            result.set("hostToHost", this.summaryHostToHost.json(mapper));
            result.set("pointToPoint", this.summaryPointToPoint.json(mapper));
            result.set("multiPointToSinglePoint", this.summaryMultiPointToSinglePoint.json(mapper));
            result.set("singlePointToMultiPoint", this.summarySinglePointToMultiPoint.json(mapper));
            result.set("path", this.summaryPath.json(mapper));
            result.set("linkCollection", this.summaryLinkCollection.json(mapper));
            result.set("opticalCircuit", this.summaryOpticalCircuit.json(mapper));
            result.set("opticalConnectivity", this.summaryOpticalConnectivity.json(mapper));
            result.set("opticalOdu", this.summaryOpticalOdu.json(mapper));
            result.set("unknownType", this.summaryUnknownType.json(mapper));
            result.set("all", this.summaryAll.json(mapper));
            return result;
        }

        private String summary() {
            StringBuilder builder = new StringBuilder();
            builder.append(SUMMARY_TITLES);
            builder.append("\n" + SEPARATOR);
            builder.append(this.summaryAll.summary());
            builder.append(this.summaryPointToPoint.summary());
            builder.append(this.summarySinglePointToMultiPoint.summary());
            builder.append(this.summaryMultiPointToSinglePoint.summary());
            builder.append(this.summaryHostToHost.summary());
            builder.append(this.summaryLinkCollection.summary());
            builder.append(this.summaryConnectivity.summary());
            builder.append(this.summaryPath.summary());
            builder.append(this.summaryOpticalCircuit.summary());
            builder.append(this.summaryOpticalConnectivity.summary());
            builder.append(this.summaryOpticalOdu.summary());
            builder.append(this.summaryUnknownType.summary());
            return builder.toString();
        }

        private class IntentSummary {
            private final String intentType;
            private int total = 0;
            private int installReq = 0;
            private int compiling = 0;
            private int installing = 0;
            private int installed = 0;
            private int recompiling = 0;
            private int withdrawReq = 0;
            private int withdrawing = 0;
            private int withdrawn = 0;
            private int failed = 0;
            private int unknownState = 0;

            IntentSummary(String intentType) {
                this.intentType = intentType;
            }

            void update(IntentState intentState) {
                ++this.total;
                switch (intentState) {
                    case INSTALL_REQ: {
                        ++this.installReq;
                        break;
                    }
                    case COMPILING: {
                        ++this.compiling;
                        break;
                    }
                    case INSTALLING: {
                        ++this.installing;
                        break;
                    }
                    case INSTALLED: {
                        ++this.installed;
                        break;
                    }
                    case RECOMPILING: {
                        ++this.recompiling;
                        break;
                    }
                    case WITHDRAW_REQ: {
                        ++this.withdrawReq;
                        break;
                    }
                    case WITHDRAWING: {
                        ++this.withdrawing;
                        break;
                    }
                    case WITHDRAWN: {
                        ++this.withdrawn;
                        break;
                    }
                    case FAILED: {
                        ++this.failed;
                        break;
                    }
                    default: {
                        ++this.unknownState;
                    }
                }
            }

            String summary() {
                StringBuilder builder = new StringBuilder();
                builder.append(String.format("\n%1s%s%14d%14d%14d%14d%14d%14d%14d%14d%14d%14d", IntentsListCommand.BOLD + this.intentType + IntentsListCommand.RESET, Strings.padStart((String)String.valueOf(this.total), (int)(32 - this.intentType.length()), (char)' '), this.installed, this.withdrawn, this.failed, this.installReq, this.compiling, this.installing, this.recompiling, this.withdrawReq, this.withdrawing, this.unknownState));
                builder.append("\n" + SEPARATOR);
                return builder.toString();
            }

            JsonNode json(ObjectMapper mapper) {
                ObjectNode result = mapper.createObjectNode().put("total", this.total).put("installed", this.installed).put("failed", this.failed).put("installReq", this.installReq).put("installing", this.installing).put("compiling", this.compiling).put("recompiling", this.recompiling).put("withdrawReq", this.withdrawReq).put("withdrawing", this.withdrawing).put("withdrawn", this.withdrawn).put("unknownState", this.unknownState);
                return result;
            }
        }
    }
}

