/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.Optional;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.incubator.net.tunnel.DefaultOpticalTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.DefaultTunnelDescription;
import org.onosproject.incubator.net.tunnel.IpTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.OpticalLogicId;
import org.onosproject.incubator.net.tunnel.OpticalTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelDescription;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.incubator.net.tunnel.TunnelProvider;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.provider.ProviderId;

@Command(scope="onos", name="tunnel-create", description="Supports for creating a tunnel by using IP address and optical as tunnel end point now.")
public class TunnelCreateCommand
extends AbstractShellCommand {
    @Argument(index=0, name="src", description="Source tunnel point. Only supports for IpTunnelEndPoint and OpticalTunnelEndPoint as end point now. If creates a ODUK or OCH or VLAN type tunnel, the formatter of this argument is DeviceId-PortNumber. Otherwise src means IP address.", required=true, multiValued=false)
    String src = null;
    @Argument(index=1, name="dst", description="Destination tunnel point. Only supports for IpTunnelEndPoint and OpticalTunnelEndPoint as end point now. If creates a ODUK or OCH or VLAN type tunnel, the formatter of this argument is DeviceId-PortNumber. Otherwise dst means IP address.", required=true, multiValued=false)
    String dst = null;
    @Argument(index=2, name="type", description="The type of tunnels, It includes MPLS, VLAN, VXLAN, GRE, ODUK, OCH", required=true, multiValued=false)
    String type = null;
    @Option(name="-g", aliases={"--groupId"}, description="Group flow table id which a tunnel match up", required=false, multiValued=false)
    String groupId = "0";
    @Option(name="-n", aliases={"--tunnelName"}, description="The name of tunnels", required=false, multiValued=false)
    String tunnelName = "onos";
    @Option(name="-b", aliases={"--bandwidth"}, description="The bandwidth attribute of tunnel", required=false, multiValued=false)
    String bandwidth = "1024";
    private static final String FMT = "The tunnel identity is %s";

    @Override
    protected void execute() {
        String[] dstArray;
        String[] srcArray;
        TunnelProvider service = TunnelCreateCommand.get(TunnelProvider.class);
        ProviderId producerName = new ProviderId("default", "org.onosproject.provider.tunnel.default");
        IpTunnelEndPoint srcPoint = null;
        IpTunnelEndPoint dstPoint = null;
        Tunnel.Type trueType = null;
        if ("MPLS".equals(this.type)) {
            trueType = Tunnel.Type.MPLS;
            srcPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.src));
            dstPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.dst));
        } else if ("VLAN".equals(this.type)) {
            trueType = Tunnel.Type.VLAN;
            srcArray = this.src.split("/");
            dstArray = this.dst.split("/");
            srcPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)srcArray[0])), Optional.of(PortNumber.portNumber((String)srcArray[1])), null, null, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
            dstPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)dstArray[0])), Optional.of(PortNumber.portNumber((String)dstArray[1])), null, null, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
        } else if ("VXLAN".equals(this.type)) {
            trueType = Tunnel.Type.VXLAN;
            srcPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.src));
            dstPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.dst));
        } else if ("GRE".equals(this.type)) {
            trueType = Tunnel.Type.GRE;
            srcPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.src));
            dstPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.dst));
        } else if ("ODUK".equals(this.type)) {
            trueType = Tunnel.Type.ODUK;
            srcArray = this.src.split("/");
            dstArray = this.dst.split("/");
            srcPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)srcArray[0])), Optional.of(PortNumber.portNumber((String)srcArray[1])), null, OpticalTunnelEndPoint.Type.LAMBDA, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
            dstPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)dstArray[0])), Optional.of(PortNumber.portNumber((String)dstArray[1])), null, OpticalTunnelEndPoint.Type.LAMBDA, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
        } else if ("OCH".equals(this.type)) {
            trueType = Tunnel.Type.OCH;
            srcArray = this.src.split("/");
            dstArray = this.dst.split("/");
            srcPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)srcArray[0])), Optional.of(PortNumber.portNumber((String)srcArray[1])), null, OpticalTunnelEndPoint.Type.TIMESLOT, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
            dstPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)dstArray[0])), Optional.of(PortNumber.portNumber((String)dstArray[1])), null, OpticalTunnelEndPoint.Type.TIMESLOT, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
        } else {
            this.print("Illegal tunnel type. Please input MPLS, VLAN, VXLAN, GRE, ODUK or OCH.", new Object[0]);
            return;
        }
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("bandwidth", this.bandwidth == null || "".equals(this.bandwidth) ? "0" : this.bandwidth).build();
        DefaultTunnelDescription tunnel = new DefaultTunnelDescription(null, (TunnelEndPoint)srcPoint, (TunnelEndPoint)dstPoint, trueType, new DefaultGroupId(Integer.parseInt(this.groupId)), producerName, TunnelName.tunnelName((String)this.tunnelName), null, new SparseAnnotations[]{annotations});
        TunnelId tunnelId = service.tunnelAdded((TunnelDescription)tunnel);
        if (tunnelId == null) {
            this.error("Create tunnel failed.", new Object[0]);
            return;
        }
        this.print(FMT, tunnelId.id());
    }
}

