/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.Collection;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.incubator.net.tunnel.TunnelSubscription;

@Command(scope="onos", name="tunnel-subscriptions", description="Query all request orders of consumer by consumer id. It's used by consumers.")
public class TunnelQuerySubscriptionCommand
extends AbstractShellCommand {
    @Argument(index=0, name="consumerId", description="consumer id means provider id", required=true, multiValued=false)
    String consumerId = null;
    private static final String FMT = "appId=%s, src=%s, dst=%s,type=%s, tunnelId=%s";

    @Override
    protected void execute() {
        TunnelService service = TunnelQuerySubscriptionCommand.get(TunnelService.class);
        DefaultApplicationId applicationId = new DefaultApplicationId(1, this.consumerId);
        Collection tunnelSet = service.queryTunnelSubscription((ApplicationId)applicationId);
        for (TunnelSubscription order : tunnelSet) {
            this.print(FMT, order.consumerId(), order.src(), order.dst(), order.type(), order.tunnelId());
        }
    }
}

