/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.Optional;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.incubator.net.tunnel.DefaultOpticalTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.IpTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.OpticalLogicId;
import org.onosproject.incubator.net.tunnel.OpticalTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.net.Annotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.provider.ProviderId;

@Command(scope="onos", name="tunnel-return", description="Returns tunnels. It's used by consumers.")
public class TunnelReturnCommand
extends AbstractShellCommand {
    @Argument(index=0, name="consumerId", description="consumer id means application id.", required=true, multiValued=false)
    String consumerId = null;
    @Option(name="-s", aliases={"--src"}, description="Source tunnel point. Only supports for IpTunnelEndPoint and OpticalTunnelEndPoint as end point now. If deletess a ODUK or OCH type tunnel, the formatter of this argument is DeviceId-PortNumber. Otherwise src means IP address.", required=false, multiValued=false)
    String src = null;
    @Option(name="-d", aliases={"--dst"}, description="Destination tunnel point. Only supports for IpTunnelEndPoint and OpticalTunnelEndPoint as end point now. If deletess a ODUK or OCH type tunnel, the formatter of this argument is DeviceId-PortNumber. Otherwise dst means IP address.", required=false, multiValued=false)
    String dst = null;
    @Option(name="-t", aliases={"--type"}, description="The type of tunnels, It includes MPLS, VLAN, VXLAN, GRE, ODUK, OCH", required=false, multiValued=false)
    String type = null;
    @Option(name="-i", aliases={"--tunnelId"}, description="the tunnel identity.", required=false, multiValued=false)
    String tunnelId = null;
    @Option(name="-n", aliases={"--tunnelName"}, description="The name of tunnels", required=false, multiValued=false)
    String tunnelName = null;

    @Override
    protected void execute() {
        Tunnel.Type trueType = null;
        TunnelService service = TunnelReturnCommand.get(TunnelService.class);
        DefaultApplicationId appId = new DefaultApplicationId(1, this.consumerId);
        ProviderId producerName = new ProviderId("default", "org.onosproject.provider.tunnel.default");
        if (!(this.isNull(this.src) || this.isNull(this.dst) || this.isNull(this.type))) {
            IpTunnelEndPoint srcPoint = null;
            IpTunnelEndPoint dstPoint = null;
            if ("MPLS".equals(this.type)) {
                trueType = Tunnel.Type.MPLS;
                srcPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.src));
                dstPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.dst));
            } else if ("VXLAN".equals(this.type)) {
                trueType = Tunnel.Type.VXLAN;
                srcPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.src));
                dstPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.dst));
            } else if ("GRE".equals(this.type)) {
                trueType = Tunnel.Type.GRE;
                srcPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.src));
                dstPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.dst));
            } else if ("VLAN".equals(this.type)) {
                trueType = Tunnel.Type.VLAN;
                String[] srcArray = this.src.split("-");
                String[] dstArray = this.dst.split("-");
                srcPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)srcArray[0])), Optional.of(PortNumber.portNumber((String)srcArray[1])), null, null, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
                dstPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)dstArray[0])), Optional.of(PortNumber.portNumber((String)dstArray[1])), null, null, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
            } else if ("ODUK".equals(this.type)) {
                trueType = Tunnel.Type.ODUK;
                String[] srcArray = this.src.split("-");
                String[] dstArray = this.dst.split("-");
                srcPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)srcArray[0])), Optional.of(PortNumber.portNumber((String)srcArray[1])), null, OpticalTunnelEndPoint.Type.LAMBDA, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
                dstPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)dstArray[0])), Optional.of(PortNumber.portNumber((String)dstArray[1])), null, OpticalTunnelEndPoint.Type.LAMBDA, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
            } else if ("OCH".equals(this.type)) {
                trueType = Tunnel.Type.OCH;
                String[] srcArray = this.src.split("-");
                String[] dstArray = this.dst.split("-");
                srcPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)srcArray[0])), Optional.of(PortNumber.portNumber((String)srcArray[1])), null, OpticalTunnelEndPoint.Type.TIMESLOT, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
                dstPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)dstArray[0])), Optional.of(PortNumber.portNumber((String)dstArray[1])), null, OpticalTunnelEndPoint.Type.TIMESLOT, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
            } else {
                this.print("Illegal tunnel type. Please input MPLS, VLAN, VXLAN, GRE, ODUK or OCH.", new Object[0]);
                return;
            }
            service.returnTunnel((ApplicationId)appId, (TunnelEndPoint)srcPoint, (TunnelEndPoint)dstPoint, trueType, new Annotations[0]);
        }
        if (!this.isNull(this.tunnelId)) {
            TunnelId id = TunnelId.valueOf((String)this.tunnelId);
            service.returnTunnel((ApplicationId)appId, id, new Annotations[0]);
        }
        if (!this.isNull(this.tunnelName)) {
            TunnelName name = TunnelName.tunnelName((String)this.tunnelName);
            service.returnTunnel((ApplicationId)appId, name, new Annotations[0]);
        }
    }

    private boolean isNull(String s) {
        return s == null || "".equals(s);
    }
}

