/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net.vnet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualDevice;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.utils.Comparators;

@Command(scope="onos", name="vnet-devices", description="Lists all virtual devices in a virtual network.")
public class VirtualDeviceListCommand
extends AbstractShellCommand {
    private static final String FMT_VIRTUAL_DEVICE = "deviceId=%s";
    @Argument(index=0, name="networkId", description="Network ID", required=true, multiValued=false)
    Long networkId = null;

    @Override
    protected void execute() {
        this.getSortedVirtualDevices().forEach(this::printVirtualDevice);
    }

    private List<VirtualDevice> getSortedVirtualDevices() {
        VirtualNetworkService service = VirtualDeviceListCommand.get(VirtualNetworkService.class);
        ArrayList<VirtualDevice> virtualDevices = new ArrayList<VirtualDevice>();
        virtualDevices.addAll(service.getVirtualDevices(NetworkId.networkId((long)this.networkId)));
        Collections.sort(virtualDevices, Comparators.VIRTUAL_DEVICE_COMPARATOR);
        return virtualDevices;
    }

    private void printVirtualDevice(VirtualDevice virtualDevice) {
        this.print(FMT_VIRTUAL_DEVICE, virtualDevice.id());
    }
}

