/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Strings;
import java.util.LinkedList;
import java.util.List;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TpPort;
import org.onlab.packet.VlanId;
import org.onlab.util.Bandwidth;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.EthType;
import org.onosproject.cli.net.ExtHeader;
import org.onosproject.cli.net.Icmp6Code;
import org.onosproject.cli.net.Icmp6Type;
import org.onosproject.cli.net.IpProtocol;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.net.intent.constraint.EncapsulationConstraint;
import org.onosproject.net.intent.constraint.PartialFailureConstraint;

public abstract class ConnectivityIntentCommand
extends AbstractShellCommand {
    @Option(name="-s", aliases={"--ethSrc"}, description="Source MAC Address", required=false, multiValued=false)
    private String srcMacString = null;
    @Option(name="-d", aliases={"--ethDst"}, description="Destination MAC Address", required=false, multiValued=false)
    private String dstMacString = null;
    @Option(name="-t", aliases={"--ethType"}, description="Ethernet Type", required=false, multiValued=false)
    private String ethTypeString = null;
    @Option(name="-v", aliases={"--vlan"}, description="VLAN ID", required=false, multiValued=false)
    private String vlanString = null;
    @Option(name="--ipProto", description="IP Protocol", required=false, multiValued=false)
    private String ipProtoString = null;
    @Option(name="--ipSrc", description="Source IP Prefix", required=false, multiValued=false)
    private String srcIpString = null;
    @Option(name="--ipDst", description="Destination IP Prefix", required=false, multiValued=false)
    private String dstIpString = null;
    @Option(name="--fLabel", description="IPv6 Flow Label", required=false, multiValued=false)
    private String fLabelString = null;
    @Option(name="--icmp6Type", description="ICMPv6 Type", required=false, multiValued=false)
    private String icmp6TypeString = null;
    @Option(name="--icmp6Code", description="ICMPv6 Code", required=false, multiValued=false)
    private String icmp6CodeString = null;
    @Option(name="--ndTarget", description="IPv6 Neighbor Discovery Target Address", required=false, multiValued=false)
    private String ndTargetString = null;
    @Option(name="--ndSLL", description="IPv6 Neighbor Discovery Source Link-Layer", required=false, multiValued=false)
    private String ndSllString = null;
    @Option(name="--ndTLL", description="IPv6 Neighbor Discovery Target Link-Layer", required=false, multiValued=false)
    private String ndTllString = null;
    @Option(name="--tcpSrc", description="Source TCP Port", required=false, multiValued=false)
    private String srcTcpString = null;
    @Option(name="--tcpDst", description="Destination TCP Port", required=false, multiValued=false)
    private String dstTcpString = null;
    @Option(name="--extHdr", description="IPv6 Extension Header Pseudo-field", required=false, multiValued=true)
    private List<String> extHdrStringList = null;
    @Option(name="-a", aliases={"--appId"}, description="Application Id", required=false, multiValued=false)
    private String appId = null;
    @Option(name="-k", aliases={"--key"}, description="Intent Key", required=false, multiValued=false)
    private String intentKey = null;
    @Option(name="--setEthSrc", description="Rewrite Source MAC Address", required=false, multiValued=false)
    private String setEthSrcString = null;
    @Option(name="--setEthDst", description="Rewrite Destination MAC Address", required=false, multiValued=false)
    private String setEthDstString = null;
    @Option(name="--setIpSrc", description="Rewrite Source IP Address", required=false, multiValued=false)
    private String setIpSrcString = null;
    @Option(name="--setIpDst", description="Rewrite Destination IP Address", required=false, multiValued=false)
    private String setIpDstString = null;
    @Option(name="--setVlan", description="Rewrite VLAN ID", required=false, multiValued=false)
    private String setVlan = null;
    @Option(name="--popVlan", description="Pop VLAN Tag", required=false, multiValued=false)
    private boolean popVlan = false;
    @Option(name="--pushVlan", description="Push VLAN ID", required=false, multiValued=false)
    private String pushVlan = null;
    @Option(name="--setQueue", description="Set Queue ID (for OpenFlow 1.0, also the port has to be specified, i.e., <port>/<queue>", required=false, multiValued=false)
    private String setQueue = null;
    @Option(name="-p", aliases={"--priority"}, description="Priority", required=false, multiValued=false)
    private int priority = 100;
    @Option(name="-b", aliases={"--bandwidth"}, description="Bandwidth", required=false, multiValued=false)
    private String bandwidthString = null;
    @Option(name="--partial", description="Allow partial installation", required=false, multiValued=false)
    private boolean partial = false;
    @Option(name="-e", aliases={"--encapsulation"}, description="Encapsulation type", required=false, multiValued=false)
    private String encapsulationString = null;

    protected TrafficSelector buildTrafficSelector() {
        IpPrefix srcIpPrefix = null;
        IpPrefix dstIpPrefix = null;
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        if (!Strings.isNullOrEmpty((String)this.srcIpString)) {
            srcIpPrefix = IpPrefix.valueOf((String)this.srcIpString);
            if (srcIpPrefix.isIp4()) {
                selectorBuilder.matchIPSrc(srcIpPrefix);
            } else {
                selectorBuilder.matchIPv6Src(srcIpPrefix);
            }
        }
        if (!Strings.isNullOrEmpty((String)this.dstIpString)) {
            dstIpPrefix = IpPrefix.valueOf((String)this.dstIpString);
            if (dstIpPrefix.isIp4()) {
                selectorBuilder.matchIPDst(dstIpPrefix);
            } else {
                selectorBuilder.matchIPv6Dst(dstIpPrefix);
            }
        }
        if (srcIpPrefix != null && dstIpPrefix != null && srcIpPrefix.version() != dstIpPrefix.version()) {
            throw new IllegalArgumentException("IP source and destination version mismatch");
        }
        Short ethType = null;
        if (srcIpPrefix != null && srcIpPrefix.isIp6()) {
            ethType = EthType.IPV6.value();
        }
        if (dstIpPrefix != null && dstIpPrefix.isIp6()) {
            ethType = EthType.IPV6.value();
        }
        if (!Strings.isNullOrEmpty((String)this.ethTypeString)) {
            ethType = EthType.parseFromString(this.ethTypeString);
        }
        if (ethType != null) {
            selectorBuilder.matchEthType(ethType.shortValue());
        }
        if (!Strings.isNullOrEmpty((String)this.vlanString)) {
            selectorBuilder.matchVlanId(VlanId.vlanId((short)Short.parseShort(this.vlanString)));
        }
        if (!Strings.isNullOrEmpty((String)this.srcMacString)) {
            selectorBuilder.matchEthSrc(MacAddress.valueOf((String)this.srcMacString));
        }
        if (!Strings.isNullOrEmpty((String)this.dstMacString)) {
            selectorBuilder.matchEthDst(MacAddress.valueOf((String)this.dstMacString));
        }
        if (!Strings.isNullOrEmpty((String)this.ipProtoString)) {
            short ipProtoShort = IpProtocol.parseFromString(this.ipProtoString);
            selectorBuilder.matchIPProtocol((byte)ipProtoShort);
        }
        if (!Strings.isNullOrEmpty((String)this.fLabelString)) {
            selectorBuilder.matchIPv6FlowLabel(Integer.parseInt(this.fLabelString));
        }
        if (!Strings.isNullOrEmpty((String)this.icmp6TypeString)) {
            byte icmp6Type = Icmp6Type.parseFromString(this.icmp6TypeString);
            selectorBuilder.matchIcmpv6Type(icmp6Type);
        }
        if (!Strings.isNullOrEmpty((String)this.icmp6CodeString)) {
            byte icmp6Code = Icmp6Code.parseFromString(this.icmp6CodeString);
            selectorBuilder.matchIcmpv6Code(icmp6Code);
        }
        if (!Strings.isNullOrEmpty((String)this.ndTargetString)) {
            selectorBuilder.matchIPv6NDTargetAddress(Ip6Address.valueOf((String)this.ndTargetString));
        }
        if (!Strings.isNullOrEmpty((String)this.ndSllString)) {
            selectorBuilder.matchIPv6NDSourceLinkLayerAddress(MacAddress.valueOf((String)this.ndSllString));
        }
        if (!Strings.isNullOrEmpty((String)this.ndTllString)) {
            selectorBuilder.matchIPv6NDTargetLinkLayerAddress(MacAddress.valueOf((String)this.ndTllString));
        }
        if (!Strings.isNullOrEmpty((String)this.srcTcpString)) {
            selectorBuilder.matchTcpSrc(TpPort.tpPort((int)Integer.parseInt(this.srcTcpString)));
        }
        if (!Strings.isNullOrEmpty((String)this.dstTcpString)) {
            selectorBuilder.matchTcpDst(TpPort.tpPort((int)Integer.parseInt(this.dstTcpString)));
        }
        if (this.extHdrStringList != null) {
            short extHdr = 0;
            for (String extHdrString : this.extHdrStringList) {
                extHdr = (short)(extHdr | ExtHeader.parseFromString(extHdrString));
            }
            selectorBuilder.matchIPv6ExthdrFlags(extHdr);
        }
        return selectorBuilder.build();
    }

    protected TrafficTreatment buildTrafficTreatment() {
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        boolean emptyTreatment = true;
        if (!Strings.isNullOrEmpty((String)this.setEthSrcString)) {
            treatmentBuilder.setEthSrc(MacAddress.valueOf((String)this.setEthSrcString));
            emptyTreatment = false;
        }
        if (!Strings.isNullOrEmpty((String)this.setEthDstString)) {
            treatmentBuilder.setEthDst(MacAddress.valueOf((String)this.setEthDstString));
            emptyTreatment = false;
        }
        if (!Strings.isNullOrEmpty((String)this.setIpSrcString)) {
            treatmentBuilder.setIpSrc(IpAddress.valueOf((String)this.setIpSrcString));
            emptyTreatment = false;
        }
        if (!Strings.isNullOrEmpty((String)this.setIpDstString)) {
            treatmentBuilder.setIpDst(IpAddress.valueOf((String)this.setIpDstString));
            emptyTreatment = false;
        }
        if (!Strings.isNullOrEmpty((String)this.setVlan)) {
            treatmentBuilder.setVlanId(VlanId.vlanId((short)Short.parseShort(this.setVlan)));
            emptyTreatment = false;
        }
        if (this.popVlan) {
            treatmentBuilder.popVlan();
            emptyTreatment = false;
        }
        if (!Strings.isNullOrEmpty((String)this.pushVlan)) {
            treatmentBuilder.pushVlan();
            treatmentBuilder.setVlanId(VlanId.vlanId((short)Short.parseShort(this.pushVlan)));
            emptyTreatment = false;
        }
        if (!Strings.isNullOrEmpty((String)this.setQueue)) {
            if (this.setQueue.contains("/")) {
                String[] queueConfig = this.setQueue.split("/");
                PortNumber port = PortNumber.portNumber((long)Long.parseLong(queueConfig[0]));
                long queueId = Long.parseLong(queueConfig[1]);
                treatmentBuilder.setQueue(queueId, port);
            } else {
                treatmentBuilder.setQueue(Long.parseLong(this.setQueue));
            }
            emptyTreatment = false;
        }
        if (emptyTreatment) {
            return DefaultTrafficTreatment.emptyTreatment();
        }
        return treatmentBuilder.build();
    }

    protected List<Constraint> buildConstraints() {
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        if (!Strings.isNullOrEmpty((String)this.bandwidthString)) {
            Bandwidth bandwidth;
            try {
                bandwidth = Bandwidth.bps((long)Long.parseLong(this.bandwidthString));
            }
            catch (NumberFormatException e) {
                bandwidth = Bandwidth.bps((double)Double.parseDouble(this.bandwidthString));
            }
            constraints.add((Constraint)new BandwidthConstraint(bandwidth));
        }
        if (this.partial) {
            constraints.add((Constraint)new PartialFailureConstraint());
        }
        if (!Strings.isNullOrEmpty((String)this.encapsulationString)) {
            EncapsulationType encapType = EncapsulationType.valueOf((String)this.encapsulationString);
            constraints.add((Constraint)new EncapsulationConstraint(encapType));
        }
        return constraints;
    }

    @Override
    protected ApplicationId appId() {
        ApplicationId appIdForIntent;
        if (this.appId == null) {
            appIdForIntent = super.appId();
        } else {
            CoreService service = ConnectivityIntentCommand.get(CoreService.class);
            appIdForIntent = service.getAppId(this.appId);
        }
        return appIdForIntent;
    }

    protected Key key() {
        Key key = null;
        if (this.intentKey != null) {
            key = Key.of((String)this.intentKey, (ApplicationId)this.appId());
        }
        return key;
    }

    protected int priority() {
        return this.priority;
    }
}

