/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.app;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.app.ApplicationAdminService;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;

@Command(scope="onos", name="app", description="Manages application inventory")
public class ApplicationCommand
extends AbstractShellCommand {
    static final String INSTALL = "install";
    static final String UNINSTALL = "uninstall";
    static final String ACTIVATE = "activate";
    static final String DEACTIVATE = "deactivate";
    @Argument(index=0, name="command", description="Command name (install|activate|deactivate|uninstall)", required=true, multiValued=false)
    String command = null;
    @Argument(index=1, name="names", description="Application name(s) or URL(s)", required=true, multiValued=true)
    String[] names = null;

    @Override
    protected void execute() {
        ApplicationAdminService service = ApplicationCommand.get(ApplicationAdminService.class);
        if (this.command.equals(INSTALL)) {
            for (String name : this.names) {
                if (this.installApp(service, name)) continue;
                return;
            }
        } else {
            for (String name : this.names) {
                if (this.manageApp(service, name)) continue;
                return;
            }
        }
    }

    private boolean installApp(ApplicationAdminService service, String url) {
        try {
            if (url.equals("-")) {
                service.install(System.in);
            } else {
                service.install(new URL(url).openStream());
            }
        }
        catch (IOException e) {
            this.error("Unable to get URL: %s", url);
            return false;
        }
        return true;
    }

    private boolean manageApp(ApplicationAdminService service, String name) {
        String action;
        ApplicationId appId = service.getId(name);
        if (appId == null) {
            List matches = service.getApplications().stream().filter(app -> app.id().name().matches(".*\\." + name + "$")).collect(Collectors.toList());
            if (matches.size() == 1) {
                appId = ((Application)matches.iterator().next()).id();
            } else if (!matches.isEmpty()) {
                this.print("Did you mean one of: %s", matches.stream().map(Application::id).map(ApplicationId::name).collect(Collectors.toList()));
                return false;
            }
        }
        if (appId == null) {
            this.print("No such application: %s", name);
            return false;
        }
        if (this.command.equals(UNINSTALL)) {
            service.uninstall(appId);
            action = "Uninstalled";
        } else if (this.command.equals(ACTIVATE)) {
            service.activate(appId);
            action = "Activated";
        } else if (this.command.equals(DEACTIVATE)) {
            service.deactivate(appId);
            action = "Deactivated";
        } else {
            this.print("Unsupported command: %s", this.command);
            return false;
        }
        this.print("%s %s", action, appId.name());
        return true;
    }
}

