/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.HashSet;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.net.ConnectivityIntentCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;

@Command(scope="onos", name="add-multi-to-single-intent", description="Installs connectivity intent between multiple ingress devices and a single egress device")
public class AddMultiPointToSinglePointIntentCommand
extends ConnectivityIntentCommand {
    @Argument(index=0, name="ingressDevices egressDevice", description="ingressDevice/Port..ingressDevice/Port egressDevice/Port", required=true, multiValued=true)
    String[] deviceStrings = null;

    @Override
    protected void execute() {
        IntentService service = AddMultiPointToSinglePointIntentCommand.get(IntentService.class);
        if (this.deviceStrings.length < 2) {
            return;
        }
        String egressDeviceString = this.deviceStrings[this.deviceStrings.length - 1];
        ConnectPoint egress = ConnectPoint.deviceConnectPoint((String)egressDeviceString);
        HashSet<ConnectPoint> ingressPoints = new HashSet<ConnectPoint>();
        for (int index = 0; index < this.deviceStrings.length - 1; ++index) {
            String ingressDeviceString = this.deviceStrings[index];
            ConnectPoint ingress = ConnectPoint.deviceConnectPoint((String)ingressDeviceString);
            ingressPoints.add(ingress);
        }
        TrafficSelector selector = this.buildTrafficSelector();
        TrafficTreatment treatment = this.buildTrafficTreatment();
        List<Constraint> constraints = this.buildConstraints();
        MultiPointToSinglePointIntent intent = MultiPointToSinglePointIntent.builder().appId(this.appId()).key(this.key()).selector(selector).treatment(treatment).ingressPoints(ingressPoints).egressPoint(egress).constraints(constraints).priority(this.priority()).resourceGroup(this.resourceGroup()).build();
        service.submit((Intent)intent);
        this.print("Multipoint to single point intent submitted:\n%s", intent.toString());
    }
}

