/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Preconditions;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.ConfigSetter;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;

@Command(scope="onos", name="device-setconfiguration", description="Sets the configuration of the specified file to the specified device.")
public class DeviceConfigSetterCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    private String uri = null;
    @Argument(index=1, name="cfgFile", description="Configuration file", required=true, multiValued=false)
    private String cfgFile = null;
    private DeviceId deviceId;

    @Override
    protected void execute() {
        DriverService service = DeviceConfigSetterCommand.get(DriverService.class);
        this.deviceId = DeviceId.deviceId((String)this.uri);
        DriverHandler h = service.createHandler(this.deviceId, new String[0]);
        ConfigSetter config = (ConfigSetter)h.behaviour(ConfigSetter.class);
        Preconditions.checkNotNull((Object)this.cfgFile, (Object)"Configuration file cannot be null");
        this.print(config.setConfiguration(this.cfgFile), new Object[0]);
    }
}

