/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.mcast.MulticastRouteService;

@Command(scope="onos", name="mcast-delete", description="Delete a multicast route flow")
public class McastDeleteCommand
extends AbstractShellCommand {
    @Argument(index=0, name="sAddr", description="IP Address of the multicast source. '*' can be used for any source (*, G) entry", required=true, multiValued=false)
    String sAddr = null;
    @Argument(index=1, name="gAddr", description="IP Address of the multicast group. '*' can be used to denote all groups", required=true, multiValued=false)
    String gAddr = null;
    @Argument(index=2, name="egressList", description="Egress id/port", required=false, multiValued=true)
    String[] egressList = null;

    @Override
    protected void execute() {
        MulticastRouteService mcastRouteManager = McastDeleteCommand.get(MulticastRouteService.class);
        if (this.sAddr.equals("*") && this.gAddr.equals("*")) {
            mcastRouteManager.getRoutes().forEach(arg_0 -> ((MulticastRouteService)mcastRouteManager).remove(arg_0));
            return;
        }
        McastRoute mRoute = new McastRoute(IpAddress.valueOf((String)this.sAddr), IpAddress.valueOf((String)this.gAddr), McastRoute.Type.STATIC);
        if (this.egressList == null) {
            mcastRouteManager.remove(mRoute);
        } else {
            for (String egress : this.egressList) {
                ConnectPoint eCp = ConnectPoint.deviceConnectPoint((String)egress);
                mcastRouteManager.removeSink(mRoute, eCp);
            }
        }
    }
}

