/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.LinksListCommand;
import org.onosproject.cli.net.TopologyCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.device.DeviceService;

@Command(scope="onos", name="paths", description="Lists all shortest-paths paths between the specified source and destination devices")
public class PathListCommand
extends TopologyCommand {
    private static final String SEP = "==>";
    @Argument(index=0, name="src", description="Source device ID", required=true, multiValued=false)
    String src = null;
    @Argument(index=1, name="dst", description="Destination device ID", required=true, multiValued=false)
    String dst = null;
    @Option(name="--disjoint", description="Show disjoint Paths")
    boolean disjoint = false;

    @Override
    protected void execute() {
        this.init();
        DeviceService deviceService = PathListCommand.get(DeviceService.class);
        DeviceId srcDid = DeviceId.deviceId((String)this.src);
        if (deviceService.getDevice(srcDid) == null) {
            this.print("Unknown device %s", this.src);
            return;
        }
        DeviceId dstDid = DeviceId.deviceId((String)this.dst);
        if (deviceService.getDevice(dstDid) == null) {
            this.print("Unknown device %s", this.dst);
            return;
        }
        Set paths = this.disjoint ? this.service.getDisjointPaths(this.topology, srcDid, dstDid) : this.service.getPaths(this.topology, srcDid, dstDid);
        if (this.outputJson()) {
            this.print("%s", PathListCommand.json(this, paths));
        } else {
            for (Path path : paths) {
                this.print(this.pathString(path), new Object[0]);
                if (!(path instanceof DisjointPath)) continue;
                this.print(this.pathString(((DisjointPath)path).backup()), new Object[0]);
            }
        }
    }

    public static JsonNode json(AbstractShellCommand context, Iterable<? extends Path> paths) {
        ObjectMapper mapper = context.mapper();
        ArrayNode result = mapper.createArrayNode();
        for (Path path : paths) {
            result.add(LinksListCommand.json(context, (Link)path).put("cost", path.cost()).set("links", LinksListCommand.json(context, path.links())));
            if (!(path instanceof DisjointPath)) continue;
            DisjointPath backup = (DisjointPath)path;
            result.add(LinksListCommand.json(context, (Link)backup.backup()).put("cost", backup.cost()).set("links", LinksListCommand.json(context, backup.links())));
        }
        return result;
    }

    protected String pathString(Path path) {
        StringBuilder sb = new StringBuilder();
        for (Link link : path.links()) {
            sb.append(LinksListCommand.compactLinkString(link)).append(SEP);
        }
        sb.delete(sb.lastIndexOf(SEP), sb.length());
        sb.append("; cost=").append(path.cost());
        return sb.toString();
    }
}

