/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Set;
import java.util.TreeSet;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Option;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.osgi.ServiceNotFoundException;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.JsonCodec;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractShellCommand
implements Action,
CodecContext {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-j", aliases={"--json"}, description="Output JSON", required=false, multiValued=false)
    private boolean json = false;
    private final ObjectMapper mapper = new ObjectMapper();

    public static <T> T get(Class<T> serviceClass) {
        return (T)DefaultServiceDirectory.getService(serviceClass);
    }

    protected ApplicationId appId() {
        return AbstractShellCommand.get(CoreService.class).registerApplication("org.onosproject.cli");
    }

    public void print(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    public void error(String format, Object ... args) {
        System.err.println(String.format(format, args));
    }

    public static String annotations(Annotations annotations) {
        if (annotations == null) {
            annotations = DefaultAnnotations.EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        TreeSet keys = new TreeSet(annotations.keys());
        for (String key : keys) {
            sb.append(", ").append(key).append('=').append(annotations.value(key));
        }
        return sb.toString();
    }

    public static String annotations(Annotations annotations, Set<String> excludedKeys) {
        StringBuilder sb = new StringBuilder();
        TreeSet keys = new TreeSet(annotations.keys());
        keys.removeAll(excludedKeys);
        for (String key : keys) {
            sb.append(", ").append(key).append('=').append(annotations.value(key));
        }
        return sb.toString();
    }

    public static ObjectNode annotations(ObjectMapper mapper, Annotations annotations) {
        ObjectNode result = mapper.createObjectNode();
        for (String key : annotations.keys()) {
            result.put(key, annotations.value(key));
        }
        return result;
    }

    protected boolean outputJson() {
        return this.json;
    }

    public Object execute() throws Exception {
        try {
            this.doExecute();
        }
        catch (ServiceNotFoundException e) {
            this.error(e.getMessage(), new Object[0]);
        }
        return null;
    }

    protected void doExecute() throws Exception {
        try {
            this.execute();
        }
        catch (ServiceNotFoundException e) {
            this.error(e.getMessage(), new Object[0]);
        }
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public <T> JsonCodec<T> codec(Class<T> entityClass) {
        return AbstractShellCommand.get(CodecService.class).getCodec(entityClass);
    }

    public <T> T getService(Class<T> serviceClass) {
        return AbstractShellCommand.get(serviceClass);
    }

    public <T> ObjectNode jsonForEntity(T entity, Class<T> entityClass) {
        return this.codec(entityClass).encode(entity, (CodecContext)this);
    }
}

