/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli;

import java.util.Formatter;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.osgi.framework.Bundle;
import org.osgi.service.component.runtime.ServiceComponentRuntime;

@Service
@Command(scope="onos", name="scr-list", description="List components")
public class ScrListCommand
extends AbstractShellCommand {
    @Override
    protected void doExecute() {
        StringBuilder output = new StringBuilder();
        Formatter formatter = new Formatter(output);
        ServiceComponentRuntime scrService = ScrListCommand.get(ServiceComponentRuntime.class);
        scrService.getComponentDescriptionDTOs(new Bundle[0]).forEach(componentDto -> scrService.getComponentConfigurationDTOs(componentDto).forEach(configurationDto -> {
            String state;
            switch (configurationDto.state) {
                case 8: {
                    state = "ACTIVE";
                    break;
                }
                case 4: {
                    state = "SATISFIED";
                    break;
                }
                default: {
                    state = "UNKNOWN";
                }
            }
            formatter.format("%3d | %9s | %s\n", configurationDto.id, state, componentDto.name);
        }));
        this.print(output.toString(), new Object[0]);
    }
}

