/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.key.DeviceKey;
import org.onosproject.net.key.DeviceKeyService;
import org.onosproject.utils.Comparators;

@Service
@Command(scope="onos", name="device-keys", description="Lists all device keys")
public class DeviceKeyListCommand
extends AbstractShellCommand {
    private static final String FMT_COMMUNITY_NAME = "identifier=%s, type=%s, community name=%s";
    private static final String FMT_USERNAME_PASSWORD = "identifier=%s, type=%s, username=%s, password=%s";

    @Override
    protected void doExecute() {
        DeviceKeyService service = DeviceKeyListCommand.get(DeviceKeyService.class);
        for (DeviceKey deviceKey : this.getSortedDeviceKeys(service)) {
            this.printDeviceKey(deviceKey);
        }
    }

    protected List<DeviceKey> getSortedDeviceKeys(DeviceKeyService service) {
        ArrayList deviceKeys = Lists.newArrayList((Iterable)service.getDeviceKeys());
        Collections.sort(deviceKeys, Comparators.DEVICE_KEY_COMPARATOR);
        return deviceKeys;
    }

    private void printDeviceKey(DeviceKey deviceKey) {
        if (DeviceKey.Type.COMMUNITY_NAME.equals((Object)deviceKey.type())) {
            this.print(FMT_COMMUNITY_NAME, deviceKey.deviceKeyId().id(), deviceKey.type(), deviceKey.asCommunityName().name());
        } else if (DeviceKey.Type.USERNAME_PASSWORD.equals((Object)deviceKey.type())) {
            this.print(FMT_USERNAME_PASSWORD, deviceKey.deviceKeyId().id(), deviceKey.type(), deviceKey.asUsernamePassword().username(), deviceKey.asUsernamePassword().password());
        } else {
            this.log.error("Unsupported device key type: {}" + deviceKey.type());
        }
    }
}

