/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Set;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.core.CoreService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultBand;
import org.onosproject.net.meter.DefaultMeterRequest;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterRequest;
import org.onosproject.net.meter.MeterService;

@Service
@Command(scope="onos", name="meter-add", description="Adds a meter to a device (currently for testing)")
public class MeterAddCommand
extends AbstractShellCommand {
    private Meter.Unit unit;
    private Set<Band> bands = new HashSet<Band>();
    private Long rate;
    private Long burstSize;
    @Option(name="-bd", aliases={"--bandDrop"}, description="Assign band DROP to this meter", required=false, multiValued=false)
    private boolean hasBandDrop = false;
    @Option(name="-br", aliases={"--bandRemark"}, description="Assign band REMARK to this meter", required=false, multiValued=false)
    private boolean hasBandRemark = false;
    @Option(name="-up", aliases={"--unitPkts"}, description="Assign unit Packets per Second to this meter", required=false, multiValued=false)
    private boolean hasPkts = false;
    @Option(name="-uk", aliases={"--unitKbps"}, description="Assign unit Kilobits per Second to this meter", required=false, multiValued=false)
    private boolean hasKbps = false;
    @Option(name="-ib", aliases={"--isBurst"}, description="Set meter applicable only to burst", required=false, multiValued=false)
    private boolean isBurst = false;
    @Option(name="-b", aliases={"--bandwidth"}, description="Bandwidth", required=false, multiValued=false)
    private String bandwidthString = null;
    @Option(name="-bs", aliases={"--burstSize"}, description="Burst size", required=false, multiValued=false)
    private String burstSizeString = null;
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    @Completion(value=DeviceIdCompleter.class)
    private String uri = null;
    private final String appId = "org.onosproject.cli.meterCmd";

    private void checkOptions() {
        Band band;
        this.unit = this.hasPkts ? Meter.Unit.PKTS_PER_SEC : Meter.Unit.KB_PER_SEC;
        this.rate = !Strings.isNullOrEmpty((String)this.bandwidthString) ? Long.valueOf(Long.parseLong(this.bandwidthString)) : Long.valueOf(500L);
        this.burstSize = !Strings.isNullOrEmpty((String)this.burstSizeString) ? Long.valueOf(Long.parseLong(this.burstSizeString)) : Long.valueOf(0L);
        if (this.hasBandDrop) {
            band = DefaultBand.builder().ofType(Band.Type.DROP).withRate(this.rate.longValue()).burstSize(this.burstSize.longValue()).build();
            this.bands.add(band);
        }
        if (this.hasBandRemark) {
            band = DefaultBand.builder().ofType(Band.Type.REMARK).withRate(this.rate.longValue()).burstSize(this.burstSize.longValue()).build();
            this.bands.add(band);
        }
        if (this.bands.size() == 0) {
            band = DefaultBand.builder().ofType(Band.Type.DROP).withRate(this.rate.longValue()).burstSize(this.burstSize.longValue()).build();
            this.bands.add(band);
        }
    }

    @Override
    protected void doExecute() {
        MeterService service = MeterAddCommand.get(MeterService.class);
        CoreService coreService = MeterAddCommand.get(CoreService.class);
        DeviceId deviceId = DeviceId.deviceId((String)this.uri);
        this.checkOptions();
        MeterRequest.Builder builder = DefaultMeterRequest.builder().forDevice(deviceId).fromApp(coreService.registerApplication("org.onosproject.cli.meterCmd")).withUnit(this.unit).withBands(this.bands);
        if (this.isBurst) {
            builder = builder.burst();
        }
        MeterRequest request = builder.add();
        Meter m = service.submit(request);
        this.log.info("Requested meter with id {}: {}", (Object)m.id().toString(), (Object)m.toString());
        this.print("Requested meter with id %s: %s", m.id().toString(), m.toString());
    }
}

