/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.cli.net.PortNumberCompleter;
import org.onosproject.cli.net.PortStateCompleter;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceAdminService;
import org.onosproject.net.device.DeviceService;

@Service
@Command(scope="onos", name="portstate", description="Administratively enables or disabled a port on a device")
public class DevicePortStateCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    @Completion(value=DeviceIdCompleter.class)
    String uri = null;
    @Argument(index=1, name="portNumber", description="Port Number", required=true, multiValued=false)
    @Completion(value=PortNumberCompleter.class)
    String portNumber = null;
    @Argument(index=2, name="portState", description="Desired State. Either \"enable\" or \"disable\".", required=true, multiValued=false)
    @Completion(value=PortStateCompleter.class)
    String portState = null;

    @Override
    protected void doExecute() {
        DeviceService deviceService = DevicePortStateCommand.get(DeviceService.class);
        DeviceAdminService deviceAdminService = DevicePortStateCommand.get(DeviceAdminService.class);
        Device dev = deviceService.getDevice(DeviceId.deviceId((String)this.uri));
        if (dev == null) {
            this.print(" %s", "Device does not exist");
            return;
        }
        PortNumber pnum = PortNumber.fromString((String)this.portNumber);
        Port p = deviceService.getPort(dev.id(), pnum);
        if (p == null) {
            this.print(" %s", "Port does not exist");
            return;
        }
        if ("enable".equals(this.portState)) {
            deviceAdminService.changePortState(dev.id(), pnum, true);
        } else if ("disable".equals(this.portState)) {
            deviceAdminService.changePortState(dev.id(), pnum, false);
        } else {
            this.print(" %s", "State must be enable or disable");
        }
    }
}

