/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.HostIdCompleter;
import org.onosproject.cli.net.completer.AnnotationKeysCompleter;
import org.onosproject.net.HostId;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.HostAnnotationConfig;
import org.onosproject.net.provider.ProviderId;

@Service
@Command(scope="onos", name="annotate-host", description="Annotates host")
public class AnnotateHostCommand
extends AbstractShellCommand {
    static final ProviderId PID = new ProviderId("cli", "org.onosproject.cli", true);
    @Argument(index=0, name="uri", description="Host ID", required=true, multiValued=false)
    @Completion(value=HostIdCompleter.class)
    String uri = null;
    @Argument(index=1, name="key", description="Annotation key", required=true, multiValued=false)
    @Completion(value=AnnotationKeysCompleter.class)
    String key = null;
    @Argument(index=2, name="value", description="Annotation value (null to remove)", required=false, multiValued=false)
    String value = null;
    @Option(name="--remove-config", description="Remove annotation config")
    private boolean removeCfg = false;

    @Override
    protected void doExecute() {
        NetworkConfigService netcfgService = AnnotateHostCommand.get(NetworkConfigService.class);
        HostId hostId = HostId.hostId((String)this.uri);
        if (this.key == null) {
            this.print("[ERROR] Annotation key not specified.", new Object[0]);
            return;
        }
        HostAnnotationConfig cfg = (HostAnnotationConfig)netcfgService.getConfig((Object)hostId, HostAnnotationConfig.class);
        if (cfg == null) {
            cfg = new HostAnnotationConfig(hostId);
        }
        if (this.removeCfg) {
            cfg.annotation(this.key);
        } else {
            cfg.annotation(this.key, this.value);
        }
        netcfgService.applyConfig((Object)hostId, HostAnnotationConfig.class, cfg.node());
    }
}

