/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onlab.util.Tools;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.event.EventListener;
import org.onosproject.net.Device;
import org.onosproject.net.Host;
import org.onosproject.net.Link;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.device.DeviceAdminService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.group.GroupService;
import org.onosproject.net.host.HostAdminService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.link.LinkAdminService;
import org.onosproject.net.region.RegionAdminService;
import org.onosproject.ui.UiExtensionService;
import org.onosproject.ui.UiTopoLayoutService;

@Service
@Command(scope="onos", name="wipe-out", description="Wipes-out the entire network information base, i.e. devices, links, hosts")
public class WipeOutCommand
extends AbstractShellCommand {
    private static final String PLEASE = "please";
    @Argument(name="please", description="Confirmation phrase")
    String please = null;

    @Override
    protected void doExecute() {
        if (this.please == null || !this.please.equals(PLEASE)) {
            this.print("I'm afraid I can't do that!\nSay: %s", PLEASE);
            return;
        }
        this.wipeOutIntents();
        this.wipeOutHosts();
        this.wipeOutFlows();
        this.wipeOutGroups();
        this.wipeOutDevices();
        this.wipeOutLinks();
        this.wipeOutNetworkConfig();
        this.wipeOutLayouts();
        this.wipeOutRegions();
        this.wipeOutUiCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wipeOutIntents() {
        this.print("Wiping intents", new Object[0]);
        IntentService intentService = WipeOutCommand.get(IntentService.class);
        Set keysToWithdrawn = Sets.newConcurrentHashSet();
        Set<Intent> intentsToWithdrawn = Tools.stream((Iterable)intentService.getIntents()).filter(intent -> intentService.getIntentState(intent.key()) != IntentState.WITHDRAWN).collect(Collectors.toSet());
        intentsToWithdrawn.stream().map(Intent::key).forEach(keysToWithdrawn::add);
        CompletableFuture completableFuture = new CompletableFuture();
        IntentListener listener = e -> {
            if (e.type() == IntentEvent.Type.WITHDRAWN) {
                keysToWithdrawn.remove(((Intent)e.subject()).key());
            }
            if (keysToWithdrawn.isEmpty()) {
                completableFuture.complete(null);
            }
        };
        intentService.addListener((EventListener)listener);
        intentsToWithdrawn.forEach(arg_0 -> ((IntentService)intentService).withdraw(arg_0));
        try {
            if (!intentsToWithdrawn.isEmpty()) {
                completableFuture.get((long)intentsToWithdrawn.size() * 1500L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e2) {
            this.print("Encountered exception while withdrawing intents: " + e2.toString(), new Object[0]);
        }
        finally {
            intentService.removeListener((EventListener)listener);
        }
        intentsToWithdrawn.forEach(arg_0 -> ((IntentService)intentService).purge(arg_0));
    }

    private void wipeOutFlows() {
        this.print("Wiping Flows", new Object[0]);
        FlowRuleService flowRuleService = WipeOutCommand.get(FlowRuleService.class);
        DeviceAdminService deviceAdminService = WipeOutCommand.get(DeviceAdminService.class);
        for (Device device : deviceAdminService.getDevices()) {
            flowRuleService.purgeFlowRules(device.id());
        }
    }

    private void wipeOutGroups() {
        this.print("Wiping groups", new Object[0]);
        GroupService groupService = WipeOutCommand.get(GroupService.class);
        DeviceAdminService deviceAdminService = WipeOutCommand.get(DeviceAdminService.class);
        for (Device device : deviceAdminService.getDevices()) {
            groupService.purgeGroupEntries(device.id());
        }
    }

    private void wipeOutHosts() {
        this.print("Wiping hosts", new Object[0]);
        HostAdminService hostAdminService = WipeOutCommand.get(HostAdminService.class);
        while (hostAdminService.getHostCount() > 0) {
            try {
                for (Host host : hostAdminService.getHosts()) {
                    hostAdminService.removeHost(host.id());
                }
            }
            catch (Exception e) {
                log.info("Unable to wipe-out hosts", (Throwable)e);
            }
        }
    }

    private void wipeOutDevices() {
        this.print("Wiping devices", new Object[0]);
        DeviceAdminService deviceAdminService = WipeOutCommand.get(DeviceAdminService.class);
        while (deviceAdminService.getDeviceCount() > 0) {
            try {
                for (Device device : deviceAdminService.getDevices()) {
                    deviceAdminService.removeDevice(device.id());
                }
            }
            catch (Exception e) {
                log.info("Unable to wipe-out devices", (Throwable)e);
            }
        }
    }

    private void wipeOutLinks() {
        this.print("Wiping links", new Object[0]);
        LinkAdminService linkAdminService = WipeOutCommand.get(LinkAdminService.class);
        while (linkAdminService.getLinkCount() > 0) {
            try {
                for (Link link : linkAdminService.getLinks()) {
                    linkAdminService.removeLinks(link.src());
                    linkAdminService.removeLinks(link.dst());
                }
            }
            catch (Exception e) {
                log.info("Unable to wipe-out links", (Throwable)e);
            }
        }
    }

    private void wipeOutLayouts() {
        this.print("Wiping UI layouts", new Object[0]);
        UiTopoLayoutService service = WipeOutCommand.get(UiTopoLayoutService.class);
        service.getLayouts().forEach(l -> {
            if (!l.id().isDefault()) {
                service.removeLayout(l);
            }
        });
    }

    private void wipeOutRegions() {
        this.print("Wiping regions", new Object[0]);
        RegionAdminService service = WipeOutCommand.get(RegionAdminService.class);
        service.getRegions().forEach(r -> service.removeRegion(r.id()));
    }

    private void wipeOutNetworkConfig() {
        this.print("Wiping network configs", new Object[0]);
        WipeOutCommand.get(NetworkConfigService.class).removeConfig();
    }

    private void wipeOutUiCache() {
        this.print("Wiping ui model cache", new Object[0]);
        WipeOutCommand.get(UiExtensionService.class).refreshModel();
    }
}

