/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.BasicSystemOperations;
import org.onosproject.net.device.DeviceService;

@Service
@Command(scope="onos", name="device-time", description="Returns the current time on the target device")
public class DeviceTimeCommand
extends AbstractShellCommand {
    @Argument(index=0, name="deviceId", description="Device ID", required=true, multiValued=false)
    @Completion(value=DeviceIdCompleter.class)
    String deviceId = null;

    @Override
    protected void doExecute() {
        Device dev = DeviceTimeCommand.get(DeviceService.class).getDevice(DeviceId.deviceId((String)this.deviceId));
        if (dev == null) {
            this.print(" %s", "Device does not exist");
            return;
        }
        if (dev.is(BasicSystemOperations.class)) {
            try {
                CompletableFuture timeFuture = ((BasicSystemOperations)dev.as(BasicSystemOperations.class)).time();
                this.print("Current time on the device: %s %d", this.deviceId, timeFuture.get());
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Exception while getting system time for device" + this.deviceId, (Throwable)e);
            }
        } else {
            log.error("Device does not support {} behaviour", (Object)BasicSystemOperations.class.getName());
        }
    }
}

