/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.Optional;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.ProtectedTransportIntent;

@Service
@Command(scope="onos", name="add-protected-transport", description="Adds ProtectedTransportIntent")
public class AddProtectedTransportIntentCommand
extends AbstractShellCommand {
    @Option(name="--key", aliases={"-k"}, description="Intent key", required=false, multiValued=false)
    private String keyStr = null;
    @Argument(index=0, name="deviceId1", description="First Device ID of protected path", required=true, multiValued=false)
    @Completion(value=DeviceIdCompleter.class)
    private String deviceId1Str = null;
    @Argument(index=1, name="deviceId2", description="Second Device ID of protected path", required=true, multiValued=false)
    @Completion(value=DeviceIdCompleter.class)
    private String deviceId2Str = null;
    private IntentService intentService;

    @Override
    protected void doExecute() {
        this.intentService = AddProtectedTransportIntentCommand.get(IntentService.class);
        DeviceId did1 = DeviceId.deviceId((String)this.deviceId1Str);
        DeviceId did2 = DeviceId.deviceId((String)this.deviceId2Str);
        ProtectedTransportIntent intent = ProtectedTransportIntent.builder().key(this.key()).appId(this.appId()).one(did1).two(did2).build();
        this.print("Submitting: %s", intent);
        this.intentService.submit((Intent)intent);
    }

    protected Key key() {
        return Optional.ofNullable(this.keyStr).map(s -> Key.of((String)s, (ApplicationId)this.appId())).orElse(null);
    }
}

